// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.serviceContainer;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.extensions.PluginAware;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.util.xmlb.annotations.Transient;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public abstract class BaseKeyedLazyInstance<T> extends LazyExtensionInstance<T> implements PluginAware {
  @SuppressWarnings("FieldAccessedSynchronizedAndUnsynchronized")
  private PluginDescriptor pluginDescriptor;

  protected BaseKeyedLazyInstance() {
  }

  @TestOnly
  protected BaseKeyedLazyInstance(@NotNull T instance) {
    super(instance);
  }

  @Transient
  public final @NotNull PluginDescriptor getPluginDescriptor() {
    return pluginDescriptor;
  }

  @Override
  public final void setPluginDescriptor(@NotNull PluginDescriptor value) {
    pluginDescriptor = value;
  }

  @Override
  protected abstract @Nullable String getImplementationClassName();

  public final @NotNull T getInstance() {
    return getInstance(ApplicationManager.getApplication(), pluginDescriptor);
  }

  // todo get rid of it - pluginDescriptor must be not null
  public @NotNull ClassLoader getLoaderForClass() {
    return pluginDescriptor != null ?
           pluginDescriptor.getClassLoader() :
           getClass().getClassLoader();
  }
}
