// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.javadoc;

import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * List of attributes (for example {@code file} or {@code class}) of a given doc tag.
 *
 * @see PsiSnippetDocTag
 */
@ApiStatus.Experimental
public interface PsiSnippetAttributeList extends PsiElement {
  /**
   * @return array of name-value pairs of snippet tag.
   */
  PsiSnippetAttribute @NotNull [] getAttributes();

  /**
   * @param name name of the attribute to find
   * @return the first instance of attribute having a given name; null if no such attribute found
   */
  @Nullable PsiSnippetAttribute getAttribute(@NotNull String name);
}
