// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.source.javadoc;

import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiJavaModule;
import ksp.com.intellij.psi.util.PsiUtil;

public class ServiceReferenceTagInfo extends ClassReferenceTagInfo {
  public ServiceReferenceTagInfo(String name) {
    super(name);
  }

  @Override
  public boolean isValidInContext(PsiElement element) {
    return element instanceof PsiJavaModule && PsiUtil.getLanguageLevel(element).isAtLeast(LanguageLevel.JDK_1_9);
  }
}