// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl.light;

import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.psi.*;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class LightTypeParameterBuilder extends LightPsiClassBuilder implements PsiTypeParameter {

  private final PsiTypeParameterListOwner myOwner;
  private final int myIndex;

  public LightTypeParameterBuilder(@NlsSafe @NotNull String name, PsiTypeParameterListOwner owner, int index) {
    super(owner, name);
    myOwner = owner;
    myIndex = index;
  }

  @Override
  public void accept(@NotNull PsiElementVisitor visitor) {
    if (visitor instanceof JavaElementVisitor) {
      ((JavaElementVisitor)visitor).visitTypeParameter(this);
    }
    else {
      visitor.visitElement(this);
    }
  }
  @Nullable
  @Override
  public PsiTypeParameterListOwner getOwner() {
    return myOwner;
  }

  @Override
  public int getIndex() {
    return myIndex;
  }

  @Override
  public PsiAnnotation @NotNull [] getAnnotations() {
    return getModifierList().getAnnotations();
  }

  @Override
  public PsiAnnotation @NotNull [] getApplicableAnnotations() {
    return getModifierList().getApplicableAnnotations();
  }

  @Nullable
  @Override
  public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
    return getModifierList().findAnnotation(qualifiedName);
  }

  @NotNull
  @Override
  public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
    return getModifierList().addAnnotation(qualifiedName);
  }
}
