// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package ksp.com.intellij.psi.impl.java.stubs;

import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface PsiMethodStub extends PsiMemberStub<PsiMethod> {
  boolean isConstructor();
  boolean isVarArgs();
  boolean isAnnotationMethod();

  @Nullable String getDefaultValueText();
  @NotNull TypeInfo getReturnTypeText();

  PsiParameterStub findParameter(int idx);
}
