// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileFilter;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.file.impl.FileManager;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.TestOnly;

public abstract class PsiManagerEx extends PsiManager {
  public static PsiManagerEx getInstanceEx(Project project) {
    //noinspection SSBasedInspection
    return (PsiManagerEx)getInstance(project);
  }

  public abstract boolean isBatchFilesProcessingMode();

  @TestOnly
  public abstract void setAssertOnFileLoadingFilter(@NotNull VirtualFileFilter filter, @NotNull Disposable parentDisposable);

  public abstract boolean isAssertOnFileLoading(@NotNull VirtualFile file);

  public abstract @NotNull FileManager getFileManager();

  public abstract void beforeChildAddition(@NotNull PsiTreeChangeEventImpl event);

  public abstract void beforeChildRemoval(@NotNull PsiTreeChangeEventImpl event);

  public abstract void beforeChildReplacement(@NotNull PsiTreeChangeEventImpl event);

  public abstract void beforeChange(boolean isPhysical);

  public abstract void afterChange(boolean isPhysical);
}
