// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.model.psi.PsiSymbolReference;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.*;
import ksp.com.intellij.psi.javadoc.PsiSnippetAttributeValue;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;


public abstract class JavaPsiImplementationHelper {
  public static JavaPsiImplementationHelper getInstance(@NotNull Project project) {
    return project.getService(JavaPsiImplementationHelper.class);
  }

  @NotNull
  public abstract PsiClass getOriginalClass(@NotNull PsiClass psiClass);

  @NotNull
  public abstract PsiJavaModule getOriginalModule(@NotNull PsiJavaModule module);

  @NotNull
  public abstract PsiElement getClsFileNavigationElement(@NotNull PsiJavaFile clsFile);

  @NotNull
  public abstract LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile);

  @Nullable
  public abstract ASTNode getDefaultImportAnchor(@NotNull PsiImportList list, @NotNull PsiImportStatementBase statement);

  @Nullable
  public abstract PsiElement getDefaultMemberAnchor(@NotNull PsiClass psiClass, @NotNull PsiMember firstPsi);

  public abstract void setupCatchBlock(@NotNull String exceptionName,
                                       @NotNull PsiType exceptionType,
                                       @Nullable PsiElement context,
                                       @NotNull PsiCatchSection element);

  public abstract @NotNull PsiSymbolReference getSnippetRegionSymbol(@NotNull PsiSnippetAttributeValue value);

}