// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.openapi.util.TextRange;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * Helper interface for PSI elements which may be added as ForeignLeaf and need to redirect annotations
 * to another text range.
 */
@FunctionalInterface
public interface ExternallyAnnotated {
  /**
   * If an inspection started for files with ForeignLeaf substitutions finds any problem in them,
   * it should be able to display it locally.
   * This method allows defining such substitution text range.
   * An example from C/C++ macro substitution:<br/><pre>
   * #define T(x) int x
   * int k;
   * T(k) = 0; // the problem [duplicate declaration 'k'] needs to be annotated
   *           // for macro parameter, not declarator
   * </pre><br/>
   * See {@link com.intellij.codeInspection.ProblemDescriptorBase} constructor for details.
   *
   * @return TextRange to which problem descriptions should be redirected, {@code null} if annotator needs to skip the problem
   */
  @Nullable
  TextRange getAnnotationRegion();
}
