// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.vfs.encoding;

import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.nio.charset.Charset;
import java.util.Collection;

public abstract class EncodingManager extends EncodingRegistry {
  public static final @NonNls String PROP_NATIVE2ASCII_SWITCH = "native2ascii";
  public static final @NonNls String PROP_PROPERTIES_FILES_ENCODING = "propertiesFilesEncoding";

  public static @NotNull EncodingManager getInstance() {
    return ApplicationManager.getApplication().getService(EncodingManager.class);
  }

  public abstract @NotNull Collection<Charset> getFavorites();

  @Override
  public abstract boolean isNative2AsciiForPropertiesFiles();

  public abstract void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile, boolean native2Ascii);

  /**
   * @return returns empty for system default
   */
  public abstract @NotNull String getDefaultCharsetName();

  public void setDefaultCharsetName(@NotNull String name) {
    throw new UnsupportedOperationException("Not implemented");
  }

  /**
   * @return null for system-default
   */
  @Override
  public abstract @Nullable Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile);

  public abstract void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile, @Nullable Charset charset);

  /**
   * @return encoding used by default in {@link com.intellij.execution.configurations.GeneralCommandLine}
   */
  @Override
  public abstract @NotNull Charset getDefaultConsoleEncoding();

  public abstract @Nullable Charset getCachedCharsetFromContent(@NotNull Document document);

  public boolean shouldAddBOMForNewUtf8File() {
    return false;
  }
}
