// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.extensions.impl

import ksp.com.intellij.openapi.components.ComponentManager
import ksp.com.intellij.openapi.extensions.LoadingOrder
import ksp.com.intellij.openapi.extensions.PluginDescriptor
import ksp.org.jetbrains.annotations.ApiStatus.Internal

@Internal
abstract class ExtensionComponentAdapter internal constructor(
  implementationClassName: String,
  @JvmField val pluginDescriptor: PluginDescriptor,
  override val orderId: String?,
  override val order: LoadingOrder,
  @JvmField internal val implementationClassResolver: ImplementationClassResolver,
) : LoadingOrder.Orderable {
  // Class or String
  @JvmField
  internal var implementationClassOrName: Any = implementationClassName

  internal abstract val isInstanceCreated: Boolean

  abstract fun <T : Any> createInstance(componentManager: ComponentManager): T?

  @Throws(ClassNotFoundException::class)
  fun <T> getImplementationClass(componentManager: ComponentManager): Class<T> {
    @Suppress("UNCHECKED_CAST")
    return implementationClassResolver.resolveImplementationClass(componentManager, this) as Class<T>
  }

  // used externally - cannot be package-local
  val assignableToClassName: String
    get() {
      val implementationClassOrName = implementationClassOrName
      return if (implementationClassOrName is String) implementationClassOrName else (implementationClassOrName as Class<*>).name
    }

  override fun toString(): String {
    return "${javaClass.simpleName}(implementation=$assignableToClassName, plugin=$pluginDescriptor)"
  }
}