// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.model.presentation;

import ksp.com.intellij.model.psi.PsiSymbolDeclaration;
import ksp.com.intellij.navigation.ItemPresentation;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface SymbolDeclarationPresentation extends ItemPresentation {

  static @Nullable SymbolDeclarationPresentation getFor(@NotNull PsiSymbolDeclaration symbolDeclaration) {
    for (SymbolDeclarationPresentationProvider declarationPresentationProvider : SymbolDeclarationPresentationProvider.EP.forKey(
      symbolDeclaration.getClass())) {
      @SuppressWarnings("unchecked")
      SymbolDeclarationPresentation presentation = declarationPresentationProvider.getPresentation(symbolDeclaration);
      if (presentation != null) {
        return presentation;
      }
    }
    return null;
  }
}
