// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.model;

import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * Convenience base class for references that resolve to a single target without additional data.
 */
public abstract class SingleTargetReference {

  /**
   * Default implementation wraps target returned from {@link #resolveSingleTarget()} into resolve result list ,
   * or returns empty list if {@link #resolveSingleTarget()} returned {@code null}.
   */
  public final @NotNull Collection<? extends Symbol> resolveReference() {
    return ContainerUtil.createMaybeSingletonList(resolveSingleTarget());
  }

  /**
   * @return the target of the reference, or {@code null} if it was not possible to resolve the reference
   */
  protected abstract @Nullable Symbol resolveSingleTarget();
}
