// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.lang.jvm.source;

import ksp.com.intellij.lang.LanguageExtension;
import ksp.com.intellij.lang.jvm.JvmElement;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * This {@link #EP extension} defines {@link PsiElement}{@code -> [}{@link JvmElement}{@code ]} mapping
 */
public interface JvmDeclarationSearcher {

  LanguageExtension<JvmDeclarationSearcher> EP = new LanguageExtension<>("com.intellij.jvm.declarationSearcher");

  @NotNull
  Collection<JvmElement> findDeclarations(@NotNull PsiElement declaringElement);
  
  default @Nullable PsiElement adjustIdentifierElement(@NotNull PsiElement identifierElement) {
    return null;
  }
}
