// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.lang.jvm.facade;

import ksp.com.intellij.lang.jvm.JvmClass;
import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.project.PossiblyDumbAware;
import ksp.com.intellij.psi.PsiElementFinder;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Allows to extend the mechanism of locating classes and packages by full-qualified name.
 * <p>
 * Similar to {@link PsiElementFinder}, but for JVM API.
 */
public interface JvmElementProvider extends PossiblyDumbAware {

  ExtensionPointName<JvmElementProvider> EP_NAME = ExtensionPointName.create("com.intellij.jvm.elementProvider");

  /**
   * Searches classes within the project for a class with the specified full-qualified name.
   *
   * @param qualifiedName the full-qualified name of the class to find
   * @param scope         - the scope to search in.
   * @return list of found classes
   */
  @NotNull
  List<? extends JvmClass> getClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope);
}
