// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.lang.java.parser;

import ksp.com.intellij.lang.PsiBuilder;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class ExpressionParser extends BasicExpressionParser {
  public ExpressionParser(@NotNull JavaParser javaParser) {
    super(javaParser, new OldExpressionParser(javaParser), new PrattExpressionParser(javaParser));
  }


  @Nullable
  @Override
  public PsiBuilder.Marker parseCaseLabel(@NotNull PsiBuilder builder) {
    return super.parseCaseLabel(builder);
  }
}