// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.lang.java;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.jvm.JvmLanguage;
import ksp.org.jetbrains.annotations.NotNull;

public final class JavaLanguage extends Language implements JvmLanguage {

  @NotNull
  public static final JavaLanguage INSTANCE = new JavaLanguage();

  private JavaLanguage() {
    super("JAVA", "text/x-java-source", "text/java", "application/x-java", "text/x-java");
  }

  @NotNull
  @Override
  public String getDisplayName() {
    return "Java";
  }

  @Override
  public boolean isCaseSensitive() {
    return true;
  }
}
