// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.lang;

import ksp.com.intellij.util.CharTable;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * Abstract syntax tree built up from light nodes.
 */
public abstract class LighterAST {
  private final CharTable myCharTable;

  public LighterAST(@NotNull CharTable charTable) {
    myCharTable = charTable;
  }

  public @NotNull CharTable getCharTable() {
    return myCharTable;
  }

  public abstract @NotNull LighterASTNode getRoot();

  public abstract @Nullable LighterASTNode getParent(final @NotNull LighterASTNode node);

  public abstract @NotNull List<LighterASTNode> getChildren(final @NotNull LighterASTNode parent);
}