// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

/*
 * @author max
 */
package ksp.com.intellij.lang;

import ksp.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.ILeafElementType;
import ksp.org.jetbrains.annotations.NotNull;

public class ForeignLeafType extends TokenWrapper implements ILeafElementType {
  public ForeignLeafType(@NotNull IElementType delegate, @NotNull CharSequence value) {
    super(delegate, value);
  }

  @Override
  public @NotNull ASTNode createLeafNode(CharSequence leafText) {
    return new ForeignLeafPsiElement(this, getValue());
  }
}
