// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.injected.editor;

import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.Segment;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.util.text.StringOperation;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Collection;

/**
 * A document used for injected PSI, based on one or several ranges from a "real" document hosting that injected PSI.
 * @see com.intellij.lang.injection.InjectedLanguageManager
 */
public interface DocumentWindow extends Document {
  /**
   * @return the host document of the injected PSI corresponding to this document
   */
  @NotNull
  Document getDelegate();

  int injectedToHost(int injectedOffset);

  @NotNull
  TextRange injectedToHost(@NotNull TextRange injectedOffset);

  int hostToInjected(int hostOffset);

  @Nullable
  TextRange getHostRange(int hostOffset);

  int injectedToHostLine(int line);

  Segment @NotNull [] getHostRanges();

  boolean areRangesEqual(@NotNull DocumentWindow documentWindow);

  /**
   * @return whether this injected document hasn't been invalidated (which could happen
   * e.g. if its document window ranges were removed or injected PSI was invalidated).
   */
  boolean isValid();

  boolean containsRange(int hostStart, int hostEnd);

  boolean isOneLine();

  /**
   * Returns set of operations which will be performed on the host document,
   * when replacement is requested on this document window.
   * <p>
   * This method doesn't modify the host document.
   */
  @NotNull Collection<@NotNull StringOperation> prepareReplaceString(int startOffset, int endOffset, @NotNull CharSequence s);
}
