// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.core;

import ksp.com.intellij.openapi.util.ModificationTracker;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.annotations.NotNull;


public class CorePsiPackageImplementationHelper extends PsiPackageImplementationHelper {
  private static final ModificationTracker[] EMPTY_DEPENDENCY = {ModificationTracker.NEVER_CHANGED};

  @NotNull
  @Override
  public GlobalSearchScope adjustAllScope(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope globalSearchScope) {
    return globalSearchScope;
  }

  @Override
  public VirtualFile @NotNull [] occursInPackagePrefixes(@NotNull PsiPackage psiPackage) {
    return VirtualFile.EMPTY_ARRAY;
  }

  @Override
  public void handleQualifiedNameChange(@NotNull PsiPackage psiPackage, @NotNull String newQualifiedName) {
  }

  @Override
  public void navigate(@NotNull PsiPackage psiPackage, boolean requestFocus) {
  }

  @Override
  public boolean packagePrefixExists(@NotNull PsiPackage psiPackage) {
    return false;
  }

  @Override
  public Object @NotNull [] getDirectoryCachedValueDependencies(@NotNull PsiPackage cachedValueProvider) {
    return EMPTY_DEPENDENCY;
  }
}
