/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.NotFoundClasses;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import ksp.org.jetbrains.kotlin.storage.StorageManager;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "", "storageManager", "Lksp/org/jetbrains/kotlin/storage/StorageManager;", "moduleDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ModuleDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "getMissingSuperClassifiers", "", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "descriptor", "missingClassifiers", "Lksp/org/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "doGetMissingClassifiers", "frontend"})
public final class MissingSupertypesResolver {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final MemoizedFunctionToNotNull<ClassifierDescriptor, Set<ClassifierDescriptor>> missingClassifiers;

    public MissingSupertypesResolver(@NotNull StorageManager storageManager, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.missingClassifiers = storageManager.createMemoizedFunction(arg_0 -> MissingSupertypesResolver.missingClassifiers$lambda$0(this, arg_0));
    }

    @NotNull
    public final Set<ClassifierDescriptor> getMissingSuperClassifiers(@NotNull ClassifierDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return (Set)this.missingClassifiers.invoke(descriptor2);
    }

    private final Set<ClassifierDescriptor> doGetMissingClassifiers(ClassifierDescriptor descriptor2) {
        Set missingSuperClassifiers = new LinkedHashSet();
        SimpleType simpleType = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType type2 = simpleType;
        for (KotlinType supertype : TypeUtilsKt.supertypes(type2)) {
            ClassId superTypeClassId;
            ClassDescriptor dependency;
            ClassifierDescriptor supertypeDeclaration = supertype.getConstructor().getDeclarationDescriptor();
            if (!(supertypeDeclaration instanceof ClassDescriptor) || ((ClassDescriptor)supertypeDeclaration).isExpect() || Intrinsics.areEqual((Object)((ClassDescriptor)supertypeDeclaration).getVisibility(), (Object)DescriptorVisibilities.LOCAL) || DescriptorUtilsKt.getClassId(supertypeDeclaration) == null || (dependency = FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, superTypeClassId)) != null && !(dependency instanceof NotFoundClasses.MockClassDescriptor)) continue;
            missingSuperClassifiers.add(supertypeDeclaration);
        }
        return CollectionsKt.toSet((Iterable)missingSuperClassifiers);
    }

    private static final Set missingClassifiers$lambda$0(MissingSupertypesResolver this$0, ClassifierDescriptor classifier) {
        Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
        return this$0.doGetMissingClassifiers(classifier);
    }
}

