/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/fir/declarations/comparators/FirValueParameterComparator;", "Ljava/util/Comparator;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "a", "b", "tree"})
public final class FirValueParameterComparator
implements Comparator<FirValueParameter> {
    @NotNull
    public static final FirValueParameterComparator INSTANCE = new FirValueParameterComparator();

    private FirValueParameterComparator() {
    }

    @Override
    public int compare(@NotNull FirValueParameter a2, @NotNull FirValueParameter b2) {
        int bHasDefaultValue;
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        int valueParameterNameDiff = a2.getName().compareTo(b2.getName());
        if (valueParameterNameDiff != 0) {
            return valueParameterNameDiff;
        }
        int valueParameterTypeDiff = FirTypeRefComparator.INSTANCE.compare(a2.getReturnTypeRef(), b2.getReturnTypeRef());
        if (valueParameterTypeDiff != 0) {
            return valueParameterTypeDiff;
        }
        int aHasDefaultValue = a2.getDefaultValue() != null ? 1 : 0;
        int defaultValueDiff = aHasDefaultValue - (bHasDefaultValue = b2.getDefaultValue() != null ? 1 : 0);
        if (defaultValueDiff != 0) {
            return defaultValueDiff;
        }
        int aIsVararg = a2.isVararg() ? 1 : 0;
        int bIsVararg = b2.isVararg() ? 1 : 0;
        return aIsVararg - bIsVararg;
    }
}

