/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtLightSourceElement;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirSyntaxChecker;", "D", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "P", "Lksp/com/intellij/psi/PsiElement;", "", "checkSyntax", "", "element", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "isApplicable", "", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkPsi", "Lksp/org/jetbrains/kotlin/KtPsiSourceElement;", "psi", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/KtPsiSourceElement;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkLightTree", "Lksp/org/jetbrains/kotlin/KtLightSourceElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/KtLightSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkPsiOrLightTree", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkers"})
public interface FirSyntaxChecker<D extends FirElement, P extends PsiElement> {
    default public void checkSyntax(@NotNull D element2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = element2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (!this.isApplicable(element2, source)) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement = (KtPsiSourceElement)source;
            PsiElement psiElement = ((KtPsiSourceElement)source).getPsi();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type P of org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirSyntaxChecker");
            this.checkPsi(element2, ktPsiSourceElement, psiElement, context2, reporter);
        } else if (ktSourceElement2 instanceof KtLightSourceElement) {
            this.checkLightTree(element2, (KtLightSourceElement)source, context2, reporter);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    default public boolean isApplicable(@NotNull D element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return true;
    }

    default public void checkPsi(@NotNull D element2, @NotNull KtPsiSourceElement source, @NotNull P psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkPsiOrLightTree(element2, source, context2, reporter);
    }

    default public void checkLightTree(@NotNull D element2, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkPsiOrLightTree(element2, source, context2, reporter);
    }

    default public void checkPsiOrLightTree(@NotNull D element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
    }
}

