/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantModalityModifierSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "<init>", "()V", "isApplicable", "", "element", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "isMemberWithRealSource", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "checkPsiOrLightTree", "", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantModalityModifierSyntaxChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantModalityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantModalityModifierSyntaxChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,59:1\n11#2:60\n*S KotlinDebug\n*F\n+ 1 RedundantModalityModifierSyntaxChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantModalityModifierSyntaxChecker\n*L\n43#1:60\n*E\n"})
public final class RedundantModalityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantModalityModifierSyntaxChecker INSTANCE = new RedundantModalityModifierSyntaxChecker();

    private RedundantModalityModifierSyntaxChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull FirDeclaration element2, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.isMemberWithRealSource(element2)) {
            if (!(element2 instanceof FirValueParameter)) return true;
        }
        KtSourceElement ktSourceElement = element2.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMemberWithRealSource(FirDeclaration $this$isMemberWithRealSource) {
        if (!($this$isMemberWithRealSource instanceof FirMemberDeclaration)) return false;
        KtSourceElement ktSourceElement = ((FirMemberDeclaration)$this$isMemberWithRealSource).getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) return false;
        return true;
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element2, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(element2 instanceof FirMemberDeclaration)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)element2;
        boolean $i$f$getModality = false;
        Modality modality = $this$modality$iv.getStatus().getModality();
        if (modality == null) {
            return;
        }
        Modality modality2 = modality;
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = FirConflictsHelpersKt.getResolvedStatus(((FirMemberDeclaration)element2).getSymbol());
        Intrinsics.checkNotNull((Object)firResolvedDeclarationStatus);
        FirResolvedDeclarationStatus resolvedStatus = firResolvedDeclarationStatus;
        Modality defaultModality = resolvedStatus.getDefaultModality();
        if (modality2 == defaultModality) {
            Object object = CollectionsKt.last(context2.getContainingDeclarations());
            FirClass firClass = object instanceof FirClass ? (FirClass)object : null;
            if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.INTERFACE) {
                return;
            }
        }
        if (LightTreePositioningStrategiesKt.modalityModifier(source.getTreeStructure(), source.getLighterASTNode()) == null) {
            return;
        }
        Set<Modality> redundantModalities = FirHelpersKt.redundantModalities((FirMemberDeclaration)element2, context2, defaultModality);
        if (redundantModalities.contains((Object)modality2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

