/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0012`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extra/RedundantCallOfConversionMethod;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "isRedundant", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "qualifiedClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "targetClassMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "checkers"})
public final class RedundantCallOfConversionMethod
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final RedundantCallOfConversionMethod INSTANCE = new RedundantCallOfConversionMethod();
    @NotNull
    private static final HashMap<String, ClassId> targetClassMap;

    private RedundantCallOfConversionMethod() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!(expression2 instanceof FirFunctionCall)) {
            return;
        }
        String string = ((FirFunctionCall)expression2).getCalleeReference().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String functionName = string;
        ClassId classId = targetClassMap.get(functionName);
        if (classId == null) {
            return;
        }
        ClassId qualifiedType = classId;
        FirExpression firExpression = ((FirFunctionCall)expression2).getExplicitReceiver();
        boolean bl2 = firExpression != null ? this.isRedundant(firExpression, qualifiedType, context2.getSession()) : false;
        if (bl2) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), null, 8, null);
        }
    }

    private final boolean isRedundant(FirExpression $this$isRedundant, ClassId qualifiedClassId, FirSession session) {
        Object object;
        if ($this$isRedundant instanceof FirLiteralExpression) {
            object = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant));
        } else if (FirTypeUtilsKt.getResolvedType($this$isRedundant) instanceof ConeFlexibleType) {
            object = null;
        } else {
            PsiElement psiElement = UtilsKt.getPsi($this$isRedundant);
            object = !((psiElement != null ? psiElement.getParent() : null) instanceof KtSafeQualifiedExpression) && (UtilsKt.getPsi($this$isRedundant) instanceof KtSafeQualifiedExpression || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant))) ? null : (ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant)) ? null : FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant), session));
        }
        ClassId thisType = object;
        return Intrinsics.areEqual((Object)thisType, (Object)qualifiedClassId);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toString", (Object)StandardClassIds.INSTANCE.getString()), TuplesKt.to((Object)"toDouble", (Object)StandardClassIds.INSTANCE.getDouble()), TuplesKt.to((Object)"toFloat", (Object)StandardClassIds.INSTANCE.getFloat()), TuplesKt.to((Object)"toLong", (Object)StandardClassIds.INSTANCE.getLong()), TuplesKt.to((Object)"toInt", (Object)StandardClassIds.INSTANCE.getInt()), TuplesKt.to((Object)"toChar", (Object)StandardClassIds.INSTANCE.getChar()), TuplesKt.to((Object)"toShort", (Object)StandardClassIds.INSTANCE.getShort()), TuplesKt.to((Object)"toByte", (Object)StandardClassIds.INSTANCE.getByte()), TuplesKt.to((Object)"toULong", (Object)StandardClassIds.INSTANCE.getULong()), TuplesKt.to((Object)"toUInt", (Object)StandardClassIds.INSTANCE.getUInt()), TuplesKt.to((Object)"toUShort", (Object)StandardClassIds.INSTANCE.getUShort()), TuplesKt.to((Object)"toUByte", (Object)StandardClassIds.INSTANCE.getUByte())};
        targetClassMap = MapsKt.hashMapOf((Pair[])pairArray);
    }
}

