/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.SuspendCallArgumentKind;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.InlineStatus;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import ksp.org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J4\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0002H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J,\u0010!\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\u001e*\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+2\f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-H\u0002J8\u0010.\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0006\u0012\u0004\u0018\u00010+\u0012\u0006\u0012\u0004\u0018\u00010&0/*\u00020\u00022\u0006\u0010'\u001a\u00020(2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J,\u00100\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00022\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00061"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "BUILTIN_SUSPEND_NAME", "Lksp/org/jetbrains/kotlin/name/Name;", "KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID", "Lksp/org/jetbrains/kotlin/name/CallableId;", "getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers", "()Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkSuspendModifierForm", "reference", "Lksp/org/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "formOfSuspendModifierForLambdaOrFun", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/SuspendCallArgumentKind;", "findEnclosingSuspendFunction", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "isInScopeForDefaultParameterValues", "", "enclosingSuspendFunction", "checkNonLocalReturnUsage", "checkRestrictsSuspension", "calledDeclarationSymbol", "isCaseMissedByK1", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "isRestrictSuspensionReceiver", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "sameInstanceOfReceiver", "useSiteReceiverExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "declarationSiteReceiverOwnerSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "computeReceiversInfo", "Lkotlin/Triple;", "checkCallableReference", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,341:1\n31#2:342\n1761#3,3:343\n543#3,4:349\n548#3:355\n774#3:357\n865#3,2:358\n1761#3,3:361\n1761#3,3:364\n46#4:346\n46#4:348\n46#4:360\n1#5:347\n53#6:353\n53#6:354\n40#6:356\n*S KotlinDebug\n*F\n+ 1 FirSuspendCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSuspendCallChecker\n*L\n57#1:342\n119#1:343,3\n143#1:349,4\n143#1:355\n263#1:357\n263#1:358,2\n277#1:361,3\n280#1:364,3\n120#1:346\n130#1:348\n267#1:360\n146#1:353\n148#1:354\n161#1:356\n*E\n"})
public final class FirSuspendCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSuspendCallChecker INSTANCE = new FirSuspendCallChecker();
    @NotNull
    private static final Name BUILTIN_SUSPEND_NAME = StandardClassIds.Callables.INSTANCE.getSuspend().getCallableName();
    @NotNull
    private static final CallableId KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID = new CallableId(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE(), BUILTIN_SUSPEND_NAME);

    private FirSuspendCallChecker() {
        super(MppCheckerKind.Common);
    }

    @NotNull
    public final CallableId getKOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID$checkers() {
        return KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirFunction enclosingSuspendFunction;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirCallableSymbol firCallableSymbol = reference2.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firCallableSymbol : null;
        if (firCallableSymbol2 == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol2;
        if (Intrinsics.areEqual((Object)reference2.getName(), (Object)BUILTIN_SUSPEND_NAME) || symbol instanceof FirNamedFunctionSymbol && Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)symbol).getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            this.checkSuspendModifierForm(expression2, reference2, symbol, context2, reporter);
        }
        if (reference2 instanceof FirResolvedCallableReference) {
            this.checkCallableReference(expression2, symbol, reporter, context2);
            return;
        }
        FirCallableSymbol firCallableSymbol3 = symbol;
        if (firCallableSymbol3 instanceof FirNamedFunctionSymbol) {
            FirCallableSymbol $this$isSuspend$iv = symbol;
            boolean $i$f$isSuspend = false;
            if (!$this$isSuspend$iv.getRawStatus().isSuspend()) {
                return;
            }
        } else if (firCallableSymbol3 instanceof FirPropertySymbol) {
            if (!Intrinsics.areEqual((Object)((FirPropertySymbol)symbol).getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
                return;
            }
        } else {
            return;
        }
        if ((enclosingSuspendFunction = this.findEnclosingSuspendFunction(context2)) == null) {
            firCallableSymbol = symbol;
            if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_FUNCTION_CALL(), (Object)symbol, null, 16, null);
            } else if (firCallableSymbol instanceof FirPropertySymbol) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_SUSPEND_PROPERTY_ACCESS(), (Object)symbol, null, 16, null);
            }
        } else {
            if (!this.checkNonLocalReturnUsage(enclosingSuspendFunction, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_LOCAL_SUSPENSION_POINT(), null, 8, null);
            }
            if (this.isInScopeForDefaultParameterValues(enclosingSuspendFunction, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Suspend function call in default parameter value is unsupported.", null, 16, null);
            }
            if (!this.checkRestrictsSuspension(expression2, enclosingSuspendFunction, symbol, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL(), null, 8, null);
            }
        }
    }

    private final void checkSuspendModifierForm(FirQualifiedAccessExpression expression2, FirResolvedNamedReference reference2, FirCallableSymbol<?> symbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)KOTLIN_SUSPEND_BUILT_IN_FUNCTION_CALLABLE_ID)) {
            if (!Intrinsics.areEqual((Object)reference2.getName(), (Object)BUILTIN_SUSPEND_NAME) || expression2.getExplicitReceiver() != null || this.formOfSuspendModifierForLambdaOrFun(expression2) == null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getNON_MODIFIER_FORM_FOR_BUILT_IN_SUSPEND(), (DiagnosticContext)context2, null, 8, null);
            }
        } else if (Intrinsics.areEqual((Object)reference2.getName(), (Object)BUILTIN_SUSPEND_NAME)) {
            SuspendCallArgumentKind suspendCallArgumentKind = this.formOfSuspendModifierForLambdaOrFun(expression2);
            switch (suspendCallArgumentKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[suspendCallArgumentKind.ordinal()]) {
                case 1: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND_FUN(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                case 2: {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getMODIFIER_FORM_FOR_NON_BUILT_IN_SUSPEND(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SuspendCallArgumentKind formOfSuspendModifierForLambdaOrFun(FirQualifiedAccessExpression $this$formOfSuspendModifierForLambdaOrFun) {
        boolean bl2;
        block19: {
            if (!($this$formOfSuspendModifierForLambdaOrFun instanceof FirFunctionCall)) {
                return null;
            }
            FirNamedReference reference2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getCalleeReference();
            if (reference2 instanceof FirResolvedCallableReference) {
                return null;
            }
            Iterable $this$any$iv = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getTypeArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirTypeProjection it = (FirTypeProjection)element$iv;
                    boolean bl3 = false;
                    if (!FirHelpersKt.isExplicit(it)) continue;
                    bl2 = true;
                    break block19;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return null;
        }
        FirCall $this$arguments$iv = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
        boolean $i$f$getArguments = false;
        FirStatement it = (FirExpression)CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        boolean bl4 = false;
        boolean bl5 = it instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)it).isTrailingLambda();
        if (bl5) {
            KtSourceElement ktSourceElement;
            KtSourceElement callExpressionSource;
            KtSourceElement ktSourceElement2;
            if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getExplicitReceiver() == null) {
                ktSourceElement2 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
            } else {
                KtSourceElement ktSourceElement3 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement3 != null) {
                    IElementType iElementType = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CALL_EXPRESSION");
                    ktSourceElement2 = FirSourceUtilsKt.getChild$default(ktSourceElement3, iElementType, 1, 1, false, 8, null);
                } else {
                    ktSourceElement2 = null;
                }
            }
            KtSourceElement ktSourceElement4 = callExpressionSource = ktSourceElement2;
            if (ktSourceElement4 != null) {
                IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
                ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement4, iElementType, 0, 1, false, 10, null);
            } else {
                ktSourceElement = null;
            }
            if (ktSourceElement == null) {
                return SuspendCallArgumentKind.LAMBDA;
            }
        }
        if (((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getOrigin() == FirFunctionCallOrigin.Infix) {
            void $this$arguments$iv2;
            it = (FirCall)((Object)$this$formOfSuspendModifierForLambdaOrFun);
            boolean $i$f$getArguments2 = false;
            FirExpression lastArgument = (FirExpression)CollectionsKt.lastOrNull($this$arguments$iv2.getArgumentList().getArguments());
            if (lastArgument instanceof FirAnonymousFunctionExpression) {
                KtSourceElement ktSourceElement;
                KtSourceElement ktSourceElement5 = ((FirFunctionCall)$this$formOfSuspendModifierForLambdaOrFun).getSource();
                if (ktSourceElement5 != null) {
                    IElementType iElementType = KtNodeTypes.PARENTHESIZED;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARENTHESIZED");
                    ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement5, iElementType, 0, 1, false, 10, null);
                } else {
                    ktSourceElement = null;
                }
                if (ktSourceElement == null) {
                    Object object = ((FirAnonymousFunctionExpression)lastArgument).getSource();
                    return Intrinsics.areEqual((Object)(object != null && (object = ((KtSourceElement)object).getLighterASTNode()) != null ? object.getTokenType() : null), (Object)KtStubElementTypes.FUNCTION) ? SuspendCallArgumentKind.FUN : SuspendCallArgumentKind.LAMBDA;
                }
            }
        }
        return null;
    }

    private final FirFunction findEnclosingSuspendFunction(CheckerContext context2) {
        FirDeclaration firDeclaration;
        block7: {
            List<FirDeclaration> $this$lastOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirDeclaration> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                boolean $i$f$isSuspend;
                FirMemberDeclaration $this$isSuspend$iv;
                boolean bl2;
                FirDeclaration element$iv;
                FirDeclaration it = element$iv = iterator$iv.previous();
                boolean bl3 = false;
                FirDeclaration firDeclaration2 = it;
                if (firDeclaration2 instanceof FirAnonymousFunction) {
                    if (((FirAnonymousFunction)it).isLambda()) {
                        bl2 = FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getConeType(((FirAnonymousFunction)it).getTypeRef()), context2.getSession());
                    } else {
                        $this$isSuspend$iv = (FirMemberDeclaration)it;
                        $i$f$isSuspend = false;
                        bl2 = $this$isSuspend$iv.getStatus().isSuspend();
                    }
                } else if (firDeclaration2 instanceof FirSimpleFunction) {
                    $this$isSuspend$iv = (FirMemberDeclaration)it;
                    $i$f$isSuspend = false;
                    bl2 = $this$isSuspend$iv.getStatus().isSuspend();
                } else {
                    bl2 = false;
                }
                if (!bl2) continue;
                firDeclaration = element$iv;
                break block7;
            }
            firDeclaration = null;
        }
        FirDeclaration firDeclaration3 = firDeclaration;
        return firDeclaration3 instanceof FirFunction ? (FirFunction)firDeclaration3 : null;
    }

    private final boolean isInScopeForDefaultParameterValues(FirFunction enclosingSuspendFunction, CheckerContext context2) {
        List<FirValueParameter> valueParameters = enclosingSuspendFunction.getValueParameters();
        for (FirDeclaration declaration2 : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (declaration2 instanceof FirValueParameter && valueParameters.contains(declaration2) && ((FirValueParameter)declaration2).getDefaultValue() != null) {
                return true;
            }
            if (declaration2 instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration2).getInlineStatus() == InlineStatus.Inline || !(declaration2 instanceof FirFunction)) continue;
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) continue;
            return false;
        }
        return false;
    }

    private final boolean checkNonLocalReturnUsage(FirFunction enclosingSuspendFunction, CheckerContext context2) {
        for (FirDeclaration declaration2 : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            if (Intrinsics.areEqual((Object)declaration2, (Object)enclosingSuspendFunction)) {
                return true;
            }
            if (declaration2 instanceof FirProperty && ((FirProperty)declaration2).isLocal() || declaration2 instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration2).getInlineStatus().getReturnAllowed() || declaration2 instanceof FirValueParameter) continue;
            return false;
        }
        return false;
    }

    private final boolean checkRestrictsSuspension(FirQualifiedAccessExpression expression2, FirFunction enclosingSuspendFunction, FirCallableSymbol<?> calledDeclarationSymbol, CheckerContext context2) {
        if (expression2 instanceof FirFunctionCall && this.isCaseMissedByK1((FirFunctionCall)expression2)) {
            return true;
        }
        FirSession session = context2.getSession();
        Object object = enclosingSuspendFunction.getDispatchReceiverType();
        FirRegularClassSymbol enclosingSuspendFunctionDispatchReceiverOwnerSymbol = object != null && (object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny((ConeKotlinType)object)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, session) : null;
        FirReceiverParameter firReceiverParameter = enclosingSuspendFunction.getReceiverParameter();
        FirReceiverParameterSymbol enclosingSuspendFunctionExtensionReceiverSymbol = firReceiverParameter != null ? firReceiverParameter.getSymbol() : null;
        Triple<FirExpression, FirExpression, ConeKotlinType> triple = this.computeReceiversInfo(expression2, session, calledDeclarationSymbol);
        FirExpression dispatchReceiverExpression = (FirExpression)triple.component1();
        FirExpression extensionReceiverExpression = (FirExpression)triple.component2();
        ConeKotlinType extensionReceiverParameterType = (ConeKotlinType)triple.component3();
        Object[] objectArray = new FirExpression[]{dispatchReceiverExpression, extensionReceiverExpression};
        for (FirExpression receiverExpression : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (!this.isRestrictSuspensionReceiver(FirTypeUtilsKt.getResolvedType(receiverExpression), session) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionDispatchReceiverOwnerSymbol) || this.sameInstanceOfReceiver(receiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) continue;
            return false;
        }
        Object object2 = enclosingSuspendFunctionExtensionReceiverSymbol;
        if (!(object2 != null && (object2 = ((FirReceiverParameterSymbol)object2).getResolvedType()) != null ? this.isRestrictSuspensionReceiver((ConeKotlinType)object2, session) : false)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(dispatchReceiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) {
            return true;
        }
        if (this.sameInstanceOfReceiver(extensionReceiverExpression, enclosingSuspendFunctionExtensionReceiverSymbol)) {
            ConeKotlinType coneKotlinType = extensionReceiverParameterType;
            boolean bl2 = coneKotlinType != null ? this.isRestrictSuspensionReceiver(coneKotlinType, session) : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCaseMissedByK1(FirFunctionCall expression2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!(expression2 instanceof FirImplicitInvokeCall)) return false;
        FirExpression firExpression = ((FirImplicitInvokeCall)expression2).getExplicitReceiver();
        Object object = firExpression;
        if (firExpression == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!CompilerConeAttributesKt.isExtensionFunctionType((ConeKotlinType)object)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        boolean bl3 = true;
        boolean isInvokeFromExtensionFunctionType = bl3;
        if (!isInvokeFromExtensionFunctionType) {
            return false;
        }
        KtSourceElement ktSourceElement = ((FirImplicitInvokeCall)expression2).getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        IElementType iElementType = KtNodeTypes.VALUE_ARGUMENT_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"VALUE_ARGUMENT_LIST");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, iElementType, 0, 1, false, 10, null);
        if (ktSourceElement2 == null) return false;
        LighterASTNode lighterASTNode = ktSourceElement2.getLighterASTNode();
        if (lighterASTNode == null) return false;
        List<LighterASTNode> list = LightTreeUtilsKt.getChildren(lighterASTNode, source.getTreeStructure());
        if (list == null) return false;
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.VALUE_ARGUMENT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int visualValueArgumentsCount = ((List)destination$iv$iv).size();
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        if (visualValueArgumentsCount == ((Collection)$this$arguments$iv.getArgumentList().getArguments()).size() - 1) return false;
        return true;
    }

    private final boolean isRestrictSuspensionReceiver(ConeKotlinType $this$isRestrictSuspensionReceiver, FirSession session) {
        ConeKotlinType coneKotlinType = $this$isRestrictSuspensionReceiver;
        if (coneKotlinType instanceof ConeClassLikeType) {
            boolean bl2;
            block10: {
                FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$isRestrictSuspensionReceiver, session, null, 2, null).getLookupTag(), session);
                if (firRegularClassSymbol == null) {
                    return false;
                }
                FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
                if (FirAnnotationUtilsKt.getAnnotationByClassId(regularClassSymbol, StandardClassIds.Annotations.INSTANCE.getRestrictsSuspension(), session) != null) {
                    return true;
                }
                Iterable $this$any$iv = regularClassSymbol.getResolvedSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeKotlinType it = (ConeKotlinType)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it, session)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            return bl2;
        }
        if (coneKotlinType instanceof ConeTypeParameterType) {
            boolean bl4;
            block11: {
                Iterable $this$any$iv = ((ConeTypeParameterType)$this$isRestrictSuspensionReceiver).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                        boolean bl5 = false;
                        if (!INSTANCE.isRestrictSuspensionReceiver(it.getConeType(), session)) continue;
                        bl4 = true;
                        break block11;
                    }
                    bl4 = false;
                }
            }
            return bl4;
        }
        return false;
    }

    private final boolean sameInstanceOfReceiver(FirExpression useSiteReceiverExpression, FirBasedSymbol<?> declarationSiteReceiverOwnerSymbol) {
        if (declarationSiteReceiverOwnerSymbol == null || useSiteReceiverExpression == null) {
            return false;
        }
        if (useSiteReceiverExpression instanceof FirThisReceiverExpression) {
            return Intrinsics.areEqual(((FirThisReceiverExpression)useSiteReceiverExpression).getCalleeReference().getBoundSymbol(), declarationSiteReceiverOwnerSymbol);
        }
        return false;
    }

    private final Triple<FirExpression, FirExpression, ConeKotlinType> computeReceiversInfo(FirQualifiedAccessExpression $this$computeReceiversInfo, FirSession session, FirCallableSymbol<?> calledDeclarationSymbol) {
        FirExpression dispatchReceiver = $this$computeReceiversInfo.getDispatchReceiver();
        if ($this$computeReceiversInfo instanceof FirImplicitInvokeCall && dispatchReceiver != null && FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(FirTypeUtilsKt.getResolvedType(dispatchReceiver), session)) {
            Object object;
            FirExpression variableForInvoke = dispatchReceiver;
            ConeKotlinType variableForInvokeType = FirTypeUtilsKt.getResolvedType(variableForInvoke);
            if (!CompilerConeAttributesKt.isExtensionFunctionType(variableForInvokeType)) {
                return new Triple(null, null, null);
            }
            return new Triple(null, CollectionsKt.getOrNull(((FirImplicitInvokeCall)$this$computeReceiversInfo).getArgumentList().getArguments(), (int)0), (Object)((object = ArraysKt.getOrNull((Object[])variableForInvokeType.getTypeArguments(), (int)0)) instanceof ConeKotlinType ? (ConeKotlinType)object : null));
        }
        return new Triple((Object)dispatchReceiver, (Object)$this$computeReceiversInfo.getExtensionReceiver(), (Object)calledDeclarationSymbol.getResolvedReceiverType());
    }

    private final void checkCallableReference(FirQualifiedAccessExpression expression2, FirCallableSymbol<?> symbol, DiagnosticReporter reporter, CheckerContext context2) {
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Callable reference to suspend property is unsupported.", (DiagnosticContext)context2, null, 16, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendCallArgumentKind.values().length];
            try {
                nArray[SuspendCallArgumentKind.FUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendCallArgumentKind.LAMBDA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

