/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirStarProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import ksp.org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirProjectionsOnNonClassTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProjectionsOnNonClassTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,41:1\n81#2,7:42\n76#2,2:49\n57#2:51\n78#2:52\n*S KotlinDebug\n*F\n+ 1 FirProjectionsOnNonClassTypeArgumentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProjectionsOnNonClassTypeArgumentChecker\n*L\n34#1:42,7\n34#1:49,2\n34#1:51\n34#1:52\n*E\n"})
public final class FirProjectionsOnNonClassTypeArgumentChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirProjectionsOnNonClassTypeArgumentChecker INSTANCE = new FirProjectionsOnNonClassTypeArgumentChecker();

    private FirProjectionsOnNonClassTypeArgumentChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        for (FirTypeProjection it : expression2.getTypeArguments()) {
            FirTypeProjection firTypeProjection = it;
            if (firTypeProjection instanceof FirStarProjection) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirStarProjection)it).getSource(), FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), null, 8, null);
                continue;
            }
            if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
                if (((FirTypeProjectionWithVariance)it).getVariance() == Variance.INVARIANT) continue;
                Object object = FirKeywordUtilsKt.getModifierList(((FirTypeProjectionWithVariance)it).getSource());
                KtSourceElement modifierSource = object != null && (object = ((FirModifierList)object).getModifiers()) != null && (object = (FirModifier)CollectionsKt.firstOrNull((List)object)) != null ? ((FirModifier)object).getSource() : null;
                DiagnosticContext diagnosticContext = context2;
                KtSourceElement ktSourceElement = modifierSource;
                if (ktSourceElement == null) {
                    ktSourceElement = ((FirTypeProjectionWithVariance)it).getSource();
                }
                KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_ON_NON_CLASS_TYPE_ARGUMENT(), null, 8, null);
                continue;
            }
            if (firTypeProjection instanceof FirPlaceholderProjection) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Placeholder projection shouldn't exist during checker phase.";
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl2 = false;
                void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl3 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "expression", expression2);
                kotlinExceptionWithAttachments.withAttachment(string, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            throw new NoWhenBranchMatchedException();
        }
    }
}

