/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import ksp.org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u001a\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "isNotExplicit", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)Z", "checkAsPropertyNotSubtype", "property", "checkAsFieldNotSubtype", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyFieldTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,94:1\n55#2:95\n55#2:96\n55#2:97\n55#2:98\n*S KotlinDebug\n*F\n+ 1 FirPropertyFieldTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyFieldTypeChecker\n*L\n39#1:95\n43#1:96\n45#1:97\n49#1:98\n*E\n"})
public final class FirPropertyFieldTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyFieldTypeChecker INSTANCE = new FirPropertyFieldTypeChecker();

    private FirPropertyFieldTypeChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        v0 = declaration.getBackingField();
        if (v0 == null) {
            return;
        }
        backingField = v0;
        if (!DeclarationAttributesKt.getHasExplicitBackingField(declaration)) {
            return;
        }
        typeCheckerContext = TypeCheckerProviderContext.newTypeCheckerState$default(TypeComponentsKt.getTypeContext(context.getSession()), false, false, false, 4, null);
        if (declaration.getInitializer() != null) {
            v1 = declaration.getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)(v1 != null ? v1.getSource() : null), FirErrors.INSTANCE.getPROPERTY_INITIALIZER_WITH_EXPLICIT_FIELD_DECLARATION(), null, 8, null);
        }
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && declaration.isVal()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_FIELD_IN_VAL_PROPERTY(), null, 8, null);
        }
        if (backingField.getInitializer() != null) ** GOTO lbl-1000
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getPROPERTY_FIELD_DECLARATION_MISSING_INITIALIZER(), null, 8, null);
        } else if (backingField.getInitializer() != null) {
            $this$isLateInit$iv = backingField;
            $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_PROPERTY_FIELD_DECLARATION_WITH_INITIALIZER(), null, 8, null);
            }
        }
        $this$isLateInit$iv = backingField;
        $i$f$isLateInit = false;
        if ($this$isLateInit$iv.getStatus().isLateInit() && TypeUtilsKt.canBeNull(FirTypeUtilsKt.getConeType(backingField.getReturnTypeRef()), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getLATEINIT_NULLABLE_BACKING_FIELD(), null, 8, null);
        }
        if (declaration.getDelegate() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getBACKING_FIELD_FOR_DELEGATED_PROPERTY(), null, 8, null);
        }
        if (Intrinsics.areEqual((Object)FirTypeUtilsKt.getConeType(backingField.getReturnTypeRef()), (Object)FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)backingField.getSource(), FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_BACKING_FIELD(), null, 8, null);
            return;
        }
        if (!TypeUtilsKt.isSubtypeOf(backingField, declaration, typeCheckerContext)) {
            this.checkAsFieldNotSubtype(declaration, context, reporter);
        }
        if (!TypeUtilsKt.isSubtypeOf(declaration, backingField, typeCheckerContext)) {
            this.checkAsPropertyNotSubtype(declaration, context, reporter);
        }
    }

    private final boolean isNotExplicit(FirPropertyAccessor $this$isNotExplicit) {
        return $this$isNotExplicit == null || $this$isNotExplicit instanceof FirDefaultPropertyAccessor;
    }

    private final void checkAsPropertyNotSubtype(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        if (property2.isVar() && this.isNotExplicit(property2.getSetter())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)property2.getSource(), FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_SETTER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkAsFieldNotSubtype(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        if (this.isNotExplicit(property2.getGetter())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)property2.getSource(), FirErrors.INSTANCE.getPROPERTY_MUST_HAVE_GETTER(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

