/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataObjectContentChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)V", "checkers"})
public final class FirDataObjectContentChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirDataObjectContentChecker INSTANCE = new FirDataObjectContentChecker();

    private FirDataObjectContentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirSimpleFunction declaration2) {
        KtSourceElement source;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                FirElement firElement = declaration2;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"OVERRIDE_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
                    return;
                }
                source = declaration2.getSource();
                if (source == null || source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass firClass = object instanceof FirClass ? (FirClass)object : null;
                if (firClass == null) {
                    return;
                }
                FirClass containingClass = firClass;
                if (containingClass.getClassKind() != ClassKind.OBJECT) break block7;
                FirElement firElement2 = containingClass;
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.DATA_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"DATA_KEYWORD");
                if (FirKeywordUtilsKt.hasModifier(firElement2, ktModifierKeywordToken2)) break block8;
            }
            return;
        }
        if (FirDeclarationUtilKt.isMethodOfAny(declaration2.getSymbol()) && !Intrinsics.areEqual((Object)declaration2.getName(), (Object)OperatorNameConventions.TO_STRING)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE(), null, 8, null);
        }
    }
}

