/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassPrimaryConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,47:1\n78#2:48\n*S KotlinDebug\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n*L\n22#1:48\n*E\n"})
public final class FirDataClassPrimaryConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirDataClassPrimaryConstructorChecker INSTANCE = new FirDataClassPrimaryConstructorChecker();

    private FirDataClassPrimaryConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration2) {
        FirConstructorSymbol primaryConstructor2;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (declaration2.getClassKind() != ClassKind.CLASS) break block7;
                FirRegularClass $this$isData$iv = declaration2;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block8;
            }
            return;
        }
        FirConstructorSymbol firConstructorSymbol = primaryConstructor2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if ((firConstructorSymbol != null ? firConstructorSymbol.getSource() : null) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), null, 8, null);
            return;
        }
        List<FirValueParameterSymbol> valueParameters = primaryConstructor2.getValueParameterSymbols();
        if (valueParameters.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)primaryConstructor2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), null, 8, null);
        }
        for (FirValueParameterSymbol parameter2 : valueParameters) {
            if (parameter2.isVararg()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_VARARG_PARAMETER(), null, 8, null);
            }
            KtSourceElement ktSourceElement = parameter2.getSource();
            if (ktSourceElement != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement) : false) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_NOT_PROPERTY_PARAMETER(), null, 8, null);
        }
    }
}

