/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.name.Name;

@PhaseDescription(name="UniqueLoopLabels")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/UniqueLoopLabelsLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class UniqueLoopLabelsLowering
implements FileLoweringPass {
    public UniqueLoopLabelsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptVoid((IrElement)irFile, new IrVisitorVoid(){
            private int counter;
            private final ArrayList<Name> stack;
            {
                this.stack = new ArrayList<E>();
            }

            public void visitElement(IrElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                if (element2 instanceof IrDeclarationWithName) {
                    this.stack.add(((IrDeclarationWithName)element2).getName());
                    IrVisitorsKt.acceptChildrenVoid(element2, this);
                    CollectionsKt.removeLast((List)this.stack);
                } else {
                    IrVisitorsKt.acceptChildrenVoid(element2, this);
                }
            }

            public void visitLoop(IrLoop loop) {
                Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
                ++this.counter;
                loop.setLabel(CollectionsKt.joinToString$default((Iterable)this.stack, (CharSequence)"$", null, (CharSequence)String.valueOf(this.counter), (int)0, null, null, (int)58, null));
                super.visitLoop(loop);
            }
        });
    }
}

