/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@PhaseDescription(name="InterfaceDefaultCalls")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/InterfaceDefaultCallsLowering;", "Lksp/org/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "backend.jvm.lower"})
public final class InterfaceDefaultCallsLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InterfaceDefaultCallsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!IrUtilsKt.hasInterfaceParent(callee) || !Intrinsics.areEqual((Object)callee.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) || JvmDefaultUtilsKt.isSimpleFunctionCompiledToJvmDefault(callee, this.context.getConfig().getJvmDefaultMode())) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction redirectTarget = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), callee, false, 2, null);
        ScopeWithIr scopeWithIr = this.getCurrentFunction();
        if (Intrinsics.areEqual((Object)redirectTarget, (Object)(scopeWithIr != null ? scopeWithIr.getIrElement() : null))) {
            return super.visitCall(expression2);
        }
        IrCall newCall = JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, redirectTarget, this.context.getIrBuiltIns());
        return super.visitCall(newCall);
    }
}

