/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import ksp.org.jdom.Content;
import ksp.org.jdom.Document;
import ksp.org.jdom.IllegalDataException;
import ksp.org.jdom.IllegalNameException;
import ksp.org.jdom.Parent;
import ksp.org.jdom.Verifier;
import ksp.org.jdom.output.XMLOutputter2;

public class DocType
extends Content {
    private static final long serialVersionUID = 200L;
    protected String elementName;
    protected String publicID;
    protected String systemID;
    protected String internalSubset;

    protected DocType() {
        super(Content.CType.DocType);
    }

    public DocType(String elementName, String publicID, String systemID) {
        super(Content.CType.DocType);
        this.setElementName(elementName);
        this.setPublicID(publicID);
        this.setSystemID(systemID);
    }

    public DocType(String elementName, String systemID) {
        this(elementName, null, systemID);
    }

    public DocType(String elementName) {
        this(elementName, null, null);
    }

    public String getElementName() {
        return this.elementName;
    }

    public DocType setElementName(String elementName) {
        String reason = Verifier.checkXMLName(elementName);
        if (reason != null) {
            throw new IllegalNameException(elementName, "DocType", reason);
        }
        this.elementName = elementName;
        return this;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public DocType setPublicID(String publicID) {
        String reason = Verifier.checkPublicID(publicID);
        if (reason != null) {
            throw new IllegalDataException(publicID, "DocType", reason);
        }
        this.publicID = publicID;
        return this;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public DocType setSystemID(String systemID) {
        String reason = Verifier.checkSystemLiteral(systemID);
        if (reason != null) {
            throw new IllegalDataException(systemID, "DocType", reason);
        }
        this.systemID = systemID;
        return this;
    }

    @Override
    public String getValue() {
        return "";
    }

    public void setInternalSubset(String newData) {
        this.internalSubset = newData;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String toString() {
        return "[DocType: " + new XMLOutputter2().outputString(this) + "]";
    }

    @Override
    public DocType clone() {
        return (DocType)super.clone();
    }

    @Override
    public DocType detach() {
        return (DocType)super.detach();
    }

    @Override
    protected DocType setParent(Parent parent2) {
        return (DocType)super.setParent(parent2);
    }

    @Override
    public Document getParent() {
        return (Document)super.getParent();
    }
}

