/*
 * Decompiled with CFR 0.152.
 */
package ksp.kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.kotlinx.serialization.KSerializer;
import ksp.kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import ksp.kotlinx.serialization.descriptors.PolymorphicKind;
import ksp.kotlinx.serialization.descriptors.SerialDescriptor;
import ksp.kotlinx.serialization.descriptors.SerialDescriptorsKt;
import ksp.kotlinx.serialization.encoding.Decoder;
import ksp.kotlinx.serialization.encoding.Encoder;
import ksp.kotlinx.serialization.json.JsonArray;
import ksp.kotlinx.serialization.json.JsonArraySerializer;
import ksp.kotlinx.serialization.json.JsonDecoder;
import ksp.kotlinx.serialization.json.JsonElement;
import ksp.kotlinx.serialization.json.JsonElementSerializer;
import ksp.kotlinx.serialization.json.JsonElementSerializersKt;
import ksp.kotlinx.serialization.json.JsonObject;
import ksp.kotlinx.serialization.json.JsonObjectSerializer;
import ksp.kotlinx.serialization.json.JsonPrimitive;
import ksp.kotlinx.serialization.json.JsonPrimitiveSerializer;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lksp/kotlinx/serialization/json/JsonElementSerializer;", "Lksp/kotlinx/serialization/KSerializer;", "Lksp/kotlinx/serialization/json/JsonElement;", "()V", "descriptor", "Lksp/kotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lksp/kotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lksp/kotlinx/serialization/encoding/Encoder;", "value", "kotlinx-serialization-json"})
@PublishedApi
public final class JsonElementSerializer
implements KSerializer<JsonElement> {
    @NotNull
    public static final JsonElementSerializer INSTANCE = new JsonElementSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildSerialDescriptor("ksp.kotlinx.serialization.json.JsonElement", PolymorphicKind.SEALED.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)((Function1)descriptor.1.INSTANCE));

    private JsonElementSerializer() {
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull JsonElement value2) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        JsonElementSerializersKt.access$verify(encoder2);
        JsonElement jsonElement = value2;
        if (jsonElement instanceof JsonPrimitive) {
            encoder2.encodeSerializableValue(JsonPrimitiveSerializer.INSTANCE, value2);
        } else if (jsonElement instanceof JsonObject) {
            encoder2.encodeSerializableValue(JsonObjectSerializer.INSTANCE, value2);
        } else if (jsonElement instanceof JsonArray) {
            encoder2.encodeSerializableValue(JsonArraySerializer.INSTANCE, value2);
        }
    }

    @Override
    @NotNull
    public JsonElement deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonDecoder input = JsonElementSerializersKt.asJsonDecoder(decoder);
        return input.decodeJsonElement();
    }
}

