/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.lang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ksp.com.intellij.util.lang.ClassPath;
import ksp.com.intellij.util.lang.ClasspathCache;
import ksp.com.intellij.util.lang.JarLoader;
import ksp.com.intellij.util.lang.Resource;
import ksp.com.intellij.util.lang.ResourceFile;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

final class JdkZipResourceFile
implements ResourceFile {
    private volatile SoftReference<ZipFile> zipFileSoftReference;
    private final boolean lockJars;
    private final File file;
    private static final Object lock = new Object();

    JdkZipResourceFile(@NotNull Path path, boolean lockJars) {
        if (path == null) {
            JdkZipResourceFile.$$$reportNull$$$0(0);
        }
        this.lockJars = lockJars;
        this.file = path.toFile();
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n2;
        if (stream == null) {
            JdkZipResourceFile.$$$reportNull$$$0(1);
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n2 = stream.read(bytes, count, length - count)) > 0; count += n2) {
        }
        if (bytes == null) {
            JdkZipResourceFile.$$$reportNull$$$0(2);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    ZipFile getZipFile() throws IOException {
        ZipFile zipFile;
        if (!this.lockJars) {
            return new ZipFile(this.file);
        }
        SoftReference<ZipFile> ref = this.zipFileSoftReference;
        ZipFile zipFile2 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            ZipFile zipFile3 = zipFile;
            if (zipFile3 == null) {
                JdkZipResourceFile.$$$reportNull$$$0(3);
            }
            return zipFile3;
        }
        Object object = lock;
        synchronized (object) {
            ref = this.zipFileSoftReference;
            ZipFile zipFile4 = zipFile = ref == null ? null : ref.get();
            if (zipFile != null) {
                ZipFile zipFile5 = zipFile;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                if (zipFile5 == null) {
                    JdkZipResourceFile.$$$reportNull$$$0(4);
                }
                return zipFile5;
            }
            zipFile = new ZipFile(this.file);
            this.zipFileSoftReference = new SoftReference<ZipFile>(zipFile);
        }
        ZipFile zipFile6 = zipFile;
        if (zipFile6 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(5);
        }
        return zipFile6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Class<?> findClass(@NotNull String fileName2, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        if (fileName2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(6);
        }
        ZipFile zipFile = this.getZipFile();
        try {
            byte[] bytes;
            ZipEntry entry = zipFile.getEntry(fileName2);
            if (entry == null) {
                Class<?> clazz = null;
                return clazz;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                bytes = JdkZipResourceFile.loadBytes(stream, (int)entry.getSize());
            }
            Class<?> clazz = classConsumer.consumeClassData(className, bytes);
            return clazz;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    @Override
    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> filter, @NotNull BiConsumer<? super String, ? super InputStream> consumer2) {
        if (dir == null) {
            JdkZipResourceFile.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            JdkZipResourceFile.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Resource getResource(@NotNull String name2, @NotNull JarLoader jarLoader) throws IOException {
        if (name2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(10);
        }
        if (jarLoader == null) {
            JdkZipResourceFile.$$$reportNull$$$0(11);
        }
        ZipFile zipFile = this.getZipFile();
        try {
            ZipEntry entry = zipFile.getEntry(name2);
            if (entry == null) {
                Resource resource = null;
                return resource;
            }
            ZipFileResource zipFileResource = new ZipFileResource(jarLoader.url, entry, this);
            return zipFileResource;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            Attributes attributes;
            block14: {
                ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                if (entry == null) {
                    Attributes attributes2 = null;
                    return attributes2;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    attributes = new Manifest(stream).getMainAttributes();
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Attributes attributes3 = null;
                        return attributes3;
                    }
                }
                stream.close();
            }
            return attributes;
        }
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        ClasspathCache.LoaderDataBuilder builder2 = new ClasspathCache.LoaderDataBuilder();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            builder2.addPackageFromName(entries.nextElement().getName());
        }
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder2;
        ClasspathCache.LoaderDataBuilder loaderDataBuilder2 = loaderDataBuilder;
        if (loaderDataBuilder2 == null) {
            JdkZipResourceFile.$$$reportNull$$$0(12);
        }
        return loaderDataBuilder2;
        finally {
            if (!this.lockJars) {
                zipFile.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLoader";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/lang/JdkZipResourceFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassPathCacheData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ZipFileResource
    implements Resource {
        private final URL baseUrl;
        private URL url;
        private final ZipEntry entry;
        private final JdkZipResourceFile file;

        private ZipFileResource(@NotNull URL baseUrl, @NotNull ZipEntry entry, @NotNull JdkZipResourceFile file) {
            if (baseUrl == null) {
                ZipFileResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ZipFileResource.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ZipFileResource.$$$reportNull$$$0(2);
            }
            this.baseUrl = baseUrl;
            this.entry = entry;
            this.file = file;
        }

        public String toString() {
            return this.url.toString();
        }

        @Override
        @NotNull
        public URL getURL() {
            URL result2 = this.url;
            if (result2 == null) {
                try {
                    result2 = new URL(this.baseUrl, this.entry.getName());
                }
                catch (MalformedURLException e2) {
                    throw new RuntimeException(e2);
                }
                this.url = result2;
            }
            URL uRL = result2;
            if (uRL == null) {
                ZipFileResource.$$$reportNull$$$0(3);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * Loose catch block
         */
        @Override
        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            ZipFile zipFile;
            block11: {
                block10: {
                    zipFile = this.file.getZipFile();
                    stream = zipFile.getInputStream(this.entry);
                    byArray = JdkZipResourceFile.loadBytes(stream, (int)this.entry.getSize());
                    if (stream == null) break block10;
                    stream.close();
                }
                if (byArray != null) break block11;
                ZipFileResource.$$$reportNull$$$0(4);
            }
            return byArray;
            {
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                if (!this.file.lockJars) {
                    zipFile.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/util/lang/JdkZipResourceFile$ZipFileResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

