/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.ThreadLocalCachedValue;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.com.intellij.openapi.util.ThrowableNotNullFunction;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.io.DataExternalizer;
import ksp.com.intellij.util.io.DataInputOutputUtil;
import ksp.com.intellij.util.text.ByteArrayCharSequence;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class IOUtil {
    public static final int KiB = 1024;
    public static final int MiB = 0x100000;
    public static final int GiB = 0x40000000;
    @ApiStatus.Internal
    public static final ThreadLocal<Boolean> OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP;
    @ApiStatus.Internal
    public static final String SHARED_CACHES_PROP = "idea.shared.caches";
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache;
    private static final byte[] ZEROES;
    private static final AtomicLong BITS_RESERVED_MEMORY_FIELD;

    @ApiStatus.Internal
    public static boolean useNativeByteOrderForByteBuffers() {
        Boolean forced = OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.get();
        return forced == null || forced != false;
    }

    public static boolean isSharedCachesEnabled() {
        return SystemProperties.getBooleanProperty(SHARED_CACHES_PROP, false);
    }

    private IOUtil() {
    }

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(0);
        }
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, StandardCharsets.UTF_16BE);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new IOException(e3);
        }
    }

    @NotNull
    public static String readString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(1);
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeString(@Nullable String s2, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(2);
        }
        IOUtil.writeCharSequence(s2, stream);
    }

    public static void writeCharSequence(@Nullable CharSequence s2, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(3);
        }
        if (s2 == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s2.length());
        if (s2.length() == 0) {
            return;
        }
        byte[] bytes = new byte[s2.length() * 2];
        int i2 = 0;
        int i22 = 0;
        while (i2 < s2.length()) {
            char aChar = s2.charAt(i2);
            bytes[i22] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i22 + 1] = (byte)(aChar & 0xFF);
            ++i2;
            i22 += 2;
        }
        stream.write(bytes);
    }

    public static void writeUTFTruncated(@NotNull DataOutput stream, @NotNull String text) throws IOException {
        if (stream == null) {
            IOUtil.$$$reportNull$$$0(4);
        }
        if (text == null) {
            IOUtil.$$$reportNull$$$0(5);
        }
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull String value2) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(7);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value2);
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull CharSequence value2) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(9);
        }
        IOUtil.writeUTFFast(ourReadWriteBuffersCache.getValue(), storage, value2);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(10);
        }
        return IOUtil.readUTFFast(ourReadWriteBuffersCache.getValue(), storage);
    }

    public static CharSequence readUTFCharSequence(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(11);
        }
        return IOUtil.readUTFFastCharSequence(storage);
    }

    public static byte @NotNull [] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull String value2) throws IOException {
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(13);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(14);
        }
        IOUtil.writeUTFFast(buffer, storage, (CharSequence)value2);
    }

    public static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull CharSequence value2) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(15);
        }
        if (value2 == null) {
            IOUtil.$$$reportNull$$$0(16);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(17);
        }
        if ((len = value2.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i2 = 0; i2 < len; ++i2) {
                char c2 = value2.charAt(i2);
                if (c2 >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i2 + 1] = (byte)c2;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value2.toString());
        }
        catch (UTFDataFormatException e2) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            IOUtil.writeCharSequence(value2, storage);
        }
    }

    public static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(18);
        }
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(19);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            return IOUtil.readLongString(storage);
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    @Nullable
    private static String readLongString(@NotNull DataInput storage) throws IOException {
        String result2;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(20);
        }
        if (LONGER_THAN_64K_MARKER.equals(result2 = storage.readUTF())) {
            return IOUtil.readString(storage);
        }
        return result2;
    }

    public static CharSequence readUTFFastCharSequence(@NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            IOUtil.$$$reportNull$$$0(21);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            return IOUtil.readLongString(storage);
        }
        if (len == 0) {
            return "";
        }
        byte[] data = new byte[len];
        storage.readFully(data, 0, len);
        return new ByteArrayCharSequence(data, 0, len);
    }

    public static boolean isAscii(@NotNull String str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(22);
        }
        return IOUtil.isAscii((CharSequence)str);
    }

    public static boolean isAscii(@NotNull CharSequence str) {
        if (str == null) {
            IOUtil.$$$reportNull$$$0(23);
        }
        int length = str.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (str.charAt(i2) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c2) {
        return c2 < '\u0080';
    }

    public static boolean deleteAllFilesStartingWith(@NotNull Path file) {
        if (file == null) {
            IOUtil.$$$reportNull$$$0(24);
        }
        String baseName = file.getFileName().toString();
        Path parentFile = file.getParent();
        if (parentFile == null) {
            return true;
        }
        ArrayList<Path> files2 = new ArrayList<Path>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parentFile);){
            for (Path path : directoryStream) {
                if (!path.getFileName().toString().startsWith(baseName)) continue;
                files2.add(path);
            }
        }
        catch (NoSuchFileException ignore) {
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
        boolean ok = true;
        for (Path f2 : files2) {
            try {
                FileUtil.delete(f2);
            }
            catch (IOException ignore) {
                ok = false;
            }
        }
        return ok;
    }

    public static boolean deleteAllFilesStartingWith(@NotNull File file) {
        if (file == null) {
            IOUtil.$$$reportNull$$$0(25);
        }
        String baseName = file.getName();
        File parentFile = file.getParentFile();
        File[] files2 = parentFile != null ? parentFile.listFiles(pathname -> pathname.getName().startsWith(baseName)) : null;
        boolean ok = true;
        if (files2 != null) {
            for (File f2 : files2) {
                ok &= FileUtil.delete(f2);
            }
        }
        return ok;
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Path file) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(26);
        }
        if (file == null) {
            IOUtil.$$$reportNull$$$0(27);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull File file) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(28);
        }
        if (file == null) {
            IOUtil.$$$reportNull$$$0(29);
        }
        return IOUtil.openCleanOrResetBroken(factoryComputable, () -> IOUtil.deleteAllFilesStartingWith(file));
    }

    public static <T> T openCleanOrResetBroken(@NotNull ThrowableComputable<T, ? extends IOException> factoryComputable, @NotNull Runnable cleanupCallback) throws IOException {
        if (factoryComputable == null) {
            IOUtil.$$$reportNull$$$0(30);
        }
        if (cleanupCallback == null) {
            IOUtil.$$$reportNull$$$0(31);
        }
        try {
            return factoryComputable.compute();
        }
        catch (IOException ex) {
            cleanupCallback.run();
            return factoryComputable.compute();
        }
    }

    public static void writeStringList(@NotNull DataOutput out, @NotNull Collection<String> list) throws IOException {
        if (out == null) {
            IOUtil.$$$reportNull$$$0(32);
        }
        if (list == null) {
            IOUtil.$$$reportNull$$$0(33);
        }
        DataInputOutputUtil.writeINT(out, list.size());
        for (String s2 : list) {
            IOUtil.writeUTF(out, s2);
        }
    }

    @NotNull
    public static <C extends Collection<String>> C readStringCollection(@NotNull DataInput in, @NotNull IntFunction<? extends C> collectionGenerator) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(34);
        }
        if (collectionGenerator == null) {
            IOUtil.$$$reportNull$$$0(35);
        }
        int size = DataInputOutputUtil.readINT(in);
        Collection strings2 = (Collection)collectionGenerator.apply(size);
        for (int i2 = 0; i2 < size; ++i2) {
            strings2.add(IOUtil.readUTF(in));
        }
        Collection collection = strings2;
        if (collection == null) {
            IOUtil.$$$reportNull$$$0(36);
        }
        return (C)collection;
    }

    @NotNull
    public static List<String> readStringList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IOUtil.$$$reportNull$$$0(37);
        }
        return IOUtil.readStringCollection(in, ArrayList::new);
    }

    public static void closeSafe(@NotNull Logger log, Closeable ... closeables) {
        if (log == null) {
            IOUtil.$$$reportNull$$$0(38);
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e2) {
                log.error(e2);
            }
        }
    }

    public static void closeSafe(@NotNull Logger log, AutoCloseable ... closeables) {
        if (log == null) {
            IOUtil.$$$reportNull$$$0(39);
        }
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e2) {
                log.error(e2);
            }
        }
    }

    public static void allocateFileRegion(@NotNull FileChannel channel, long upUntilSize) throws IOException {
        long channelSize;
        if (channel == null) {
            IOUtil.$$$reportNull$$$0(40);
        }
        if ((channelSize = channel.size()) < upUntilSize) {
            IOUtil.fillFileRegionWithZeros(channel, channelSize, upUntilSize);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fillFileRegionWithZeros(@NotNull FileChannel channel, long startingOffset, long l2) throws IOException {
        void upUntilOffset;
        if (channel == null) {
            IOUtil.$$$reportNull$$$0(41);
        }
        int stride = ZEROES.length;
        ByteBuffer zeros = ByteBuffer.wrap(ZEROES);
        for (long pos = startingOffset; pos < upUntilOffset; pos += (long)stride) {
            int remainsToZero = Math.toIntExact(Math.min((long)stride, (long)(upUntilOffset - pos)));
            zeros.clear().limit(remainsToZero);
            channel.write(zeros, pos);
        }
    }

    public static <T> byte[] toBytes(T object, @NotNull DataExternalizer<? super T> externalizer) throws IOException {
        if (externalizer == null) {
            IOUtil.$$$reportNull$$$0(42);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(bos);){
            externalizer.save(dos, object);
        }
        return bos.toByteArray();
    }

    public static <T> T fromBytes(byte[] bytes, @NotNull DataExternalizer<? extends T> externalizer) throws IOException {
        if (externalizer == null) {
            IOUtil.$$$reportNull$$$0(43);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try (DataInputStream dis = new DataInputStream(bis);){
            T t2 = externalizer.read(dis);
            return t2;
        }
    }

    public static String toString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(44);
        }
        byte[] bytes = new byte[buffer.capacity()];
        ByteBuffer slice = buffer.duplicate();
        slice.position(0).limit(buffer.capacity());
        slice.get(bytes);
        return Arrays.toString(bytes);
    }

    @NotNull
    public static String toHexString(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(45);
        }
        return IOUtil.toHexString(buffer, -1);
    }

    @NotNull
    public static String toHexString(@NotNull ByteBuffer buffer, int pageSize) {
        if (buffer == null) {
            IOUtil.$$$reportNull$$$0(46);
        }
        byte[] bytes = new byte[buffer.capacity()];
        ByteBuffer slice = buffer.duplicate();
        slice.position(0).limit(buffer.capacity());
        slice.get(bytes);
        return IOUtil.toHexString(bytes, pageSize);
    }

    @NotNull
    public static String toHexString(byte[] bytes) {
        return IOUtil.toHexString(bytes, -1);
    }

    @NotNull
    public static String toHexString(byte[] bytes, int pageSize) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b2 = bytes[i2];
            int unsignedByte = Byte.toUnsignedInt(b2);
            if (unsignedByte < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(unsignedByte));
            if (i2 >= bytes.length - 1) continue;
            if (pageSize > 0 && i2 % pageSize == pageSize - 1) {
                sb.append('\n');
                continue;
            }
            sb.append(' ');
        }
        String string = sb.toString();
        if (string == null) {
            IOUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    public static int asciiToMagicWord(@NotNull String ascii) {
        if (ascii == null) {
            IOUtil.$$$reportNull$$$0(48);
        }
        if (ascii.length() != 4) {
            throw new IllegalArgumentException("ascii[" + ascii + "] must be 4 ASCII chars long");
        }
        byte[] bytes = ascii.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 4) {
            throw new IllegalArgumentException("ascii bytes [" + IOUtil.toHexString(bytes) + "].length must be 4");
        }
        return Byte.toUnsignedInt(bytes[0]) << 24 | Byte.toUnsignedInt(bytes[1]) << 16 | Byte.toUnsignedInt(bytes[2]) << 8 | Byte.toUnsignedInt(bytes[3]);
    }

    public static String magicWordToASCII(int magicWord) {
        byte[] ascii = new byte[]{(byte)(magicWord >> 24 & 0xFF), (byte)(magicWord >> 16 & 0xFF), (byte)(magicWord >> 8 & 0xFF), (byte)(magicWord & 0xFF)};
        return new String(ascii, StandardCharsets.US_ASCII);
    }

    public static <Out extends AutoCloseable, In extends AutoCloseable, E extends Throwable> Out wrapSafely(@NotNull In storageToWrap, @NotNull ThrowableNotNullFunction<In, Out, E> wrapperer) throws E {
        if (storageToWrap == null) {
            IOUtil.$$$reportNull$$$0(49);
        }
        if (wrapperer == null) {
            IOUtil.$$$reportNull$$$0(50);
        }
        try {
            return (Out)((AutoCloseable)wrapperer.fun(storageToWrap));
        }
        catch (Throwable mainEx) {
            try {
                storageToWrap.close();
            }
            catch (Throwable closeEx) {
                mainEx.addSuppressed(closeEx);
            }
            throw mainEx;
        }
    }

    public static long directBuffersTotalAllocatedSize() {
        if (BITS_RESERVED_MEMORY_FIELD != null) {
            return BITS_RESERVED_MEMORY_FIELD.get();
        }
        return -1L;
    }

    static {
        AtomicLong reservedMemoryCounter;
        block2: {
            OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP = new ThreadLocal<Boolean>(){

                @Override
                public void set(Boolean value2) {
                    if (this.get() != null) {
                        throw new RuntimeException("Reentrant access");
                    }
                    super.set(value2);
                }
            };
            ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

                @Override
                protected byte @NotNull [] create() {
                    byte[] byArray = IOUtil.allocReadWriteUTFBuffer();
                    if (byArray == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return byArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/util/io/IOUtil$2", "create"));
                }
            };
            ZEROES = new byte[1024];
            reservedMemoryCounter = null;
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits");
                Field reservedMemoryField = bitsClass.getDeclaredField("RESERVED_MEMORY");
                reservedMemoryField.setAccessible(true);
                reservedMemoryCounter = (AtomicLong)reservedMemoryField.get(null);
            }
            catch (Throwable t2) {
                Logger log = Logger.getInstance(IOUtil.class);
                if (!log.isDebugEnabled()) break block2;
                log.warn("Can't get java.nio.Bits.RESERVED_MEMORY", t2);
            }
        }
        BITS_RESERVED_MEMORY_FIELD = reservedMemoryCounter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 36: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 36: 
            case 47: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 14: 
            case 17: 
            case 19: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryComputable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupCallback";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionGenerator";
                break;
            }
            case 36: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/IOUtil";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ascii";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageToWrap";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/IOUtil";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringCollection";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeCharSequence";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFTruncated";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readUTFCharSequence";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeUTFFast";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFast";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readLongString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readUTFFastCharSequence";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAscii";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteAllFilesStartingWith";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "openCleanOrResetBroken";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "readStringCollection";
                break;
            }
            case 36: 
            case 47: {
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "closeSafe";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "allocateFileRegion";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fillFileRegionWithZeros";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "toBytes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fromBytes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "asciiToMagicWord";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "wrapSafely";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 36: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

