/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.util.Function;
import ksp.com.intellij.util.Functions;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.Unmodifiable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private Object myCurrent = Do.INIT;
    private Object myNext = Do.INIT;
    private Op myFirstOp;
    private Op myLastOp = this.myFirstOp = new NextOp();
    private static final Function.Mono CURSOR_NEXT = new Function.Mono<JBIterator<?>>(){

        @Override
        public JBIterator<?> fun(JBIterator<?> iterator2) {
            return (JBIterator)((JBIterator)iterator2).addOp(false, iterator2.new CursorOp());
        }
    };

    @NotNull
    public static <E extends JBIterator<?>> JBIterable<E> cursor(@NotNull E iterator2) {
        if (iterator2 == null) {
            JBIterator.$$$reportNull$$$0(0);
        }
        JBIterable jBIterable = JBIterable.generate(iterator2, Functions.id()).intercept(CURSOR_NEXT);
        if (jBIterable == null) {
            JBIterator.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<? extends E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(2);
        }
        return it instanceof JBIterator ? (JBIterator<? extends E>)it : JBIterator.wrap(it);
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<? extends E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(3);
        }
        return new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = Do.STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = Do.SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != Do.STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    @Contract(mutates="this")
    public final boolean advance() {
        this.myCurrent = Do.INIT;
        this.peekNext();
        if (this.myNext == Do.STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = Do.INIT;
        if (this.myFirstOp instanceof CursorOp) {
            ((CursorOp)this.myFirstOp).advance(this.myCurrent);
        }
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == Do.INIT) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != Do.INIT) {
            return;
        }
        Object o2 = Do.INIT;
        Op op = this.myFirstOp;
        while (op != null) {
            o2 = op.apply(op.impl == null ? this.nextImpl() : o2);
            if (this.myNext == Do.STOP) {
                return;
            }
            if (this.myNext == Do.SKIP) {
                this.myNext = Do.INIT;
                o2 = this.myNext;
                if (op.impl == null) {
                    Op op2 = this.myFirstOp;
                    while (op2.impl instanceof CountDown) {
                        ++((CountDown)op2.impl).cur;
                        op2 = op2.nextOp;
                    }
                }
                op = null;
            }
            op = op == null ? this.myFirstOp : op.nextOp;
        }
        this.myNext = o2;
    }

    @NotNull
    public final <T> JBIterator<T> map(@NotNull Function<? super E, ? extends T> function2) {
        if (function2 == null) {
            JBIterator.$$$reportNull$$$0(4);
        }
        return (JBIterator)this.addOp(true, new MapOp<E, T>(function2));
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(5);
        }
        return (JBIterator)this.addOp(true, new FilterOp<E>(condition));
    }

    @NotNull
    public final <T> JBIterator<T> filterMap(@NotNull Function<? super E, ? extends T> function2) {
        if (function2 == null) {
            JBIterator.$$$reportNull$$$0(6);
        }
        return (JBIterator)this.addOp(true, new FilterMapOp<E, T>(function2));
    }

    @NotNull
    public final JBIterator<E> take(int count) {
        return (JBIterator)this.addOp(!(this.myLastOp instanceof NextOp), new WhileOp(new CountDown(count)));
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(7);
        }
        return (JBIterator)this.addOp(true, new WhileOp<E>(condition));
    }

    @NotNull
    public final JBIterator<E> skip(int count) {
        return this.skipWhile(new CountDown(count));
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(8);
        }
        return (JBIterator)this.addOp(true, new SkipOp<E>(condition));
    }

    @NotNull
    private <T> T addOp(boolean last, @NotNull Op op) {
        if (op == null) {
            JBIterator.$$$reportNull$$$0(9);
        }
        if (op.impl == null) {
            this.myFirstOp = this.myLastOp = op;
        } else if (last) {
            this.myLastOp = this.myLastOp.nextOp = op;
        } else {
            op.nextOp = this.myFirstOp;
            this.myFirstOp = op;
        }
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(10);
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public final @Unmodifiable List<E> toList() {
        List list = Collections.unmodifiableList(ContainerUtil.newArrayList(JBIterable.once(this)));
        if (list == null) {
            JBIterator.$$$reportNull$$$0(11);
        }
        return list;
    }

    public String toString() {
        List<Op> ops = this.operationsImpl().toList();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.size() < 2 ? "" : "; ops=" + ops) + "}";
    }

    @NotNull
    public final JBIterable<Function<Object, Object>> getTransformations() {
        JBIterable<Function<Object, Object>> jBIterable = this.operationsImpl().map(op -> op.impl).filter(Function.class);
        if (jBIterable == null) {
            JBIterator.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp, op -> op.nextOp);
        if (jBIterable == null) {
            JBIterator.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    static String toShortString(@NotNull Object o2) {
        String name2;
        int idx;
        if (o2 == null) {
            JBIterator.$$$reportNull$$$0(14);
        }
        if ((idx = (name2 = o2.getClass().getName()).lastIndexOf(36)) > 0 && idx + 1 < name2.length() && StringUtil.isJavaIdentifierStart(name2.charAt(idx + 1))) {
            String string = name2.substring(idx + 1);
            if (string == null) {
                JBIterator.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = name2.substring(name2.lastIndexOf(46) + 1);
        if (string == null) {
            JBIterator.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/JBIterator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/JBIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cursor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addOp";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "operationsImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toShortString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cursor";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addOp";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toShortString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o2) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return JBIterator.toShortString(this.impl == null ? this : this.impl);
        }
    }

    private static enum Do {
        INIT,
        STOP,
        SKIP;

    }

    private static final class NextOp
    extends Op<Void> {
        NextOp() {
            super(null);
        }

        @Override
        Object apply(Object o2) {
            return o2;
        }
    }

    private final class CursorOp
    extends Op<Void> {
        boolean advanced;

        CursorOp() {
            super(null);
        }

        @Override
        Object apply(Object o2) {
            JBIterator it = (JBIterator)o2;
            boolean bl2 = this.advanced = this.nextOp != null;
            return (this.advanced ? it.advance() : it.hasNext()) ? it : JBIterator.this.stop();
        }

        void advance(Object o2) {
            if (this.advanced || !(o2 instanceof JBIterator)) {
                return;
            }
            ((JBIterator)o2).advance();
            this.advanced = true;
        }
    }

    private static final class CountDown<A>
    implements Condition<A> {
        int cur;

        CountDown(int count) {
            this.cur = count;
        }

        @Override
        public boolean value(A a2) {
            if (this.cur <= 0) {
                return false;
            }
            --this.cur;
            return true;
        }
    }

    private static final class MapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        MapOp(Function<? super E, ? extends T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o2) {
            return ((Function)this.impl).fun(o2);
        }
    }

    private final class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o2) {
            return ((Condition)this.impl).value(o2) ? o2 : JBIterator.this.skip();
        }
    }

    private final class FilterMapOp<E, T>
    extends Op<Function<? super E, ? extends T>> {
        FilterMapOp(Function<? super E, ? extends T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o2) {
            Object e2 = ((Function)this.impl).fun(o2);
            return e2 != null ? e2 : JBIterator.this.skip();
        }
    }

    private final class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o2) {
            return ((Condition)this.impl).value(o2) ? o2 : JBIterator.this.stop();
        }
    }

    private final class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        Object apply(Object o2) {
            if (this.active && ((Condition)this.impl).value(o2)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o2;
        }
    }
}

