/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ksp.com.intellij.openapi.diagnostic.LoggerRt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ReflectionUtilRt {
    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(0);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        ReflectionUtilRt.collectFields(clazz, result2);
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtilRt.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void collectFields(@NotNull Class<?> clazz, @NotNull List<? super Field> result2) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            ReflectionUtilRt.$$$reportNull$$$0(3);
        }
        result2.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtilRt.collectFields(superClass, result2);
        }
        for (Class<?> each : clazz.getInterfaces()) {
            ReflectionUtilRt.collectFields(each, result2);
        }
    }

    @NotNull
    public static List<Method> collectGetters(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(4);
        }
        List<Method> methods = ReflectionUtilRt.collectMethods(clazz);
        ArrayList<Method> result2 = new ArrayList<Method>();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || methodName.equals("getClass")) continue;
            result2.add(method);
        }
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtilRt.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<Method> collectMethods(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(6);
        }
        ArrayList<Method> result2 = new ArrayList<Method>();
        ReflectionUtilRt.collectMethods(clazz, result2);
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtilRt.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void collectMethods(@NotNull Class<?> clazz, @NotNull List<? super Method> result2) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            ReflectionUtilRt.$$$reportNull$$$0(9);
        }
        result2.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtilRt.collectMethods(superClass, result2);
        }
        for (Class<?> each : clazz.getInterfaces()) {
            ReflectionUtilRt.collectMethods(each, result2);
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull String fieldName) {
        Field field;
        if (objectClass == null) {
            ReflectionUtilRt.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            ReflectionUtilRt.$$$reportNull$$$0(11);
        }
        if ((field = ReflectionUtilRt.findField(objectClass, fieldName, fieldType)) != null) {
            try {
                return (T)field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field findField(@NotNull Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        Field result2;
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(12);
        }
        if (fieldName == null) {
            ReflectionUtilRt.$$$reportNull$$$0(13);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName()) || fieldType != null && !fieldType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtilRt.findField(superClass, fieldName, fieldType)) != null) {
            return result2;
        }
        for (Class<?> each : clazz.getInterfaces()) {
            Field result3 = ReflectionUtilRt.findField(each, fieldName, fieldType);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e2) {
            LoggerRt.getInstance(ReflectionUtilRt.class).warn(e2);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGetters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethods";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectGetters";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectMethods";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

