/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiImportList;
import ksp.com.intellij.psi.PsiImportStatementBase;
import ksp.com.intellij.psi.PsiImportStaticReferenceElement;
import ksp.com.intellij.psi.PsiImportStaticStatement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ImportsUtil {
    private static final Key<Boolean> IS_IMPLICIT = Key.create("IMPORT_IS_IMPLICIT");

    private ImportsUtil() {
    }

    public static List<PsiJavaCodeReferenceElement> collectReferencesThrough(PsiFile file, final @Nullable PsiJavaCodeReferenceElement refExpr, final PsiImportStaticStatement staticImport) {
        final ArrayList<PsiJavaCodeReferenceElement> expressionToExpand = new ArrayList<PsiJavaCodeReferenceElement>();
        file.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement expression2) {
                PsiElement resolveScope;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refExpr != expression2 && (resolveScope = expression2.advancedResolve(true).getCurrentFileResolveScope()) == staticImport) {
                    expressionToExpand.add(expression2);
                }
                super.visitElement(expression2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "ksp/com/intellij/psi/util/ImportsUtil$1", "visitReferenceElement"));
            }
        });
        return expressionToExpand;
    }

    public static void replaceAllAndDeleteImport(List<PsiJavaCodeReferenceElement> expressionToExpand, @Nullable PsiJavaCodeReferenceElement refExpr, PsiImportStaticStatement staticImport) {
        if (refExpr != null) {
            expressionToExpand.add(refExpr);
        }
        expressionToExpand.sort((o1, o2) -> o2.getTextOffset() - o1.getTextOffset());
        for (PsiJavaCodeReferenceElement expression2 : expressionToExpand) {
            ImportsUtil.expand(expression2, staticImport);
        }
        staticImport.delete();
    }

    public static void expand(@NotNull PsiJavaCodeReferenceElement ref, PsiImportStaticStatement staticImport) {
        if (ref == null) {
            ImportsUtil.$$$reportNull$$$0(0);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(ref.getProject());
        PsiClass targetClass = staticImport.resolveTargetClass();
        assert (targetClass != null);
        if (ref instanceof PsiReferenceExpression) {
            ((PsiReferenceExpression)ref).setQualifierExpression(elementFactory.createReferenceExpression(targetClass));
        } else if (ref instanceof PsiImportStaticReferenceElement) {
            ref.replace(Objects.requireNonNull(elementFactory.createImportStaticStatement(targetClass, ref.getText()).getImportReference()));
        } else {
            ref.replace(elementFactory.createReferenceFromText(targetClass.getQualifiedName() + "." + ref.getText(), ref));
        }
    }

    public static boolean hasStaticImportOn(PsiElement expr, PsiMember member, boolean acceptOnDemand) {
        PsiImportList importList;
        if (expr.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)expr.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements;
            for (PsiImportStaticStatement stmt : importStaticStatements = importList.getImportStaticStatements()) {
                PsiClass containingClass = member.getContainingClass();
                String referenceName = stmt.getReferenceName();
                if (containingClass == null || stmt.resolveTargetClass() != containingClass) continue;
                if (!stmt.isOnDemand() && Comparing.strEqual(referenceName, member.getName())) {
                    if (member instanceof PsiMethod) {
                        return containingClass.findMethodsByName(referenceName, false).length > 0;
                    }
                    return true;
                }
                if (!acceptOnDemand || !stmt.isOnDemand()) continue;
                return true;
            }
        }
        return false;
    }

    public static void markAsImplicitImport(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            ImportsUtil.$$$reportNull$$$0(1);
        }
        importStatement.putUserData(IS_IMPLICIT, Boolean.TRUE);
    }

    public static boolean isImplicitImport(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            ImportsUtil.$$$reportNull$$$0(2);
        }
        return importStatement.getUserData(IS_IMPLICIT) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/util/ImportsUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsImplicitImport";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

