/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import ksp.com.intellij.diagnostic.ThreadDumper;
import ksp.com.intellij.extapi.psi.ASTDelegatePsiElement;
import ksp.com.intellij.lang.ASTFactory;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import ksp.com.intellij.psi.impl.source.DummyHolder;
import ksp.com.intellij.psi.impl.source.DummyHolderFactory;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import ksp.com.intellij.psi.impl.source.tree.AstBufferUtil;
import ksp.com.intellij.psi.impl.source.tree.ChangeUtil;
import ksp.com.intellij.psi.impl.source.tree.FileElement;
import ksp.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import ksp.com.intellij.psi.impl.source.tree.LazyParseableElement;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.TreeElementVisitor;
import ksp.com.intellij.psi.impl.source.tree.TreeUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.ArrayFactory;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance(CompositeElement.class);
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final AtomicReferenceFieldUpdater<CompositeElement, PsiElement> myWrapperUpdater = AtomicReferenceFieldUpdater.newUpdater(CompositeElement.class, PsiElement.class, "myWrapper");

    public CompositeElement(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(0);
        }
        super(type2);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            CompositeElement.$$$reportNull$$$0(1);
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
            CompositeElement.assertThreading((PsiFile)psi);
        }
    }

    @Override
    public void clearCaches() {
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private static void assertThreading(@NotNull PsiFile file) {
        if (file == null) {
            CompositeElement.$$$reportNull$$$0(2);
        }
        if (!ApplicationManager.getApplication().isWriteAccessAllowed() && !CompositeElement.isNonPhysicalOrInjected(file)) {
            LOG.error("Threading assertion. " + CompositeElement.getThreadingDiagnostics(file));
        }
    }

    @NonNls
    private static String getThreadingDiagnostics(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(3);
        }
        return "psiFile: " + psiFile + "; psiFile.getViewProvider(): " + psiFile.getViewProvider() + "; psiFile.isPhysical(): " + psiFile.isPhysical() + "; nonPhysicalOrInjected: " + CompositeElement.isNonPhysicalOrInjected(psiFile);
    }

    private static boolean isNonPhysicalOrInjected(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(4);
        }
        return psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor2) {
        if (visitor2 == null) {
            CompositeElement.$$$reportNull$$$0(5);
        }
        visitor2.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element2 = this;
        if (element2.getTreeParent() == null && offset >= element2.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child = ((TreeElement)element2).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element2).getLastChildNode();
            int elementTextLength = element2.getTextLength();
            boolean bl2 = fwd = lastChild == null || elementTextLength / 2 > offset;
            if (!fwd) {
                child = lastChild;
                offset = elementTextLength - offset;
            }
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset || !fwd && textLength >= offset) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = fwd ? child.getTreeNext() : child.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    offset = fwd ? offset : textLength - offset;
                    element2 = child;
                    continue block0;
                }
                offset -= textLength;
                child = fwd ? child.getTreeNext() : child.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull IElementType type2) {
        ASTNode node;
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(6);
        }
        return (node = this.findChildByType(type2)) == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull TokenSet types2) {
        ASTNode node;
        if (types2 == null) {
            CompositeElement.$$$reportNull$$$0(7);
        }
        return (node = this.findChildByType(types2)) == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(8);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (ASTNode element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (element2.getElementType() != type2) continue;
            return element2;
        }
        return null;
    }

    @Override
    public ASTNode findChildByType(@NotNull IElementType type2, ASTNode anchor) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(9);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, type2);
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types2) {
        if (types2 == null) {
            CompositeElement.$$$reportNull$$$0(10);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (ASTNode element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (!types2.contains(element2.getElementType())) continue;
            return element2;
        }
        return null;
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor) {
        if (typesSet == null) {
            CompositeElement.$$$reportNull$$$0(11);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor, typesSet);
    }

    @Override
    @NotNull
    public String getText() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return "";
        }
        if (firstChildNode == this.getLastChildNode()) {
            if (firstChildNode instanceof ForeignLeafPsiElement) {
                return "";
            }
            String string = firstChildNode.getText();
            if (string == null) {
                CompositeElement.$$$reportNull$$$0(12);
            }
            return string;
        }
        return new String(this.textToCharArray());
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return "";
        }
        if (firstChildNode == this.getLastChildNode()) {
            CharSequence charSequence = firstChildNode.getChars();
            if (charSequence == null) {
                CompositeElement.$$$reportNull$$$0(13);
            }
            return charSequence;
        }
        String string = this.getText();
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        int endOffset;
        this.assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            @NonNls String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e2);
        }
        if (endOffset != len) {
            @NonNls String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(15);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text) {
        PsiElement psi;
        @NonNls String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + CompositeElement.isNonPhysicalOrInjected(SharedImplUtil.getContainingFile(this));
        msg = msg + ";\n buffer=" + text;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e2) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file;
                msg = msg + ";\n psi.file.tl=" + file.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file.getViewProvider().getLanguages();
                PsiElement fileLeaf = file.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c2) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(16);
        }
        final int[] curOffset = new int[]{start};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element2 = this.findChildByRole(role);
        if (element2 == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element2);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(17);
        }
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(@NotNull ASTNode child, int roleCandidate) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(18);
        }
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    public ASTNode @NotNull [] getChildren(@Nullable TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            if (EMPTY_ARRAY == null) {
                CompositeElement.$$$reportNull$$$0(19);
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            result2[count++] = child;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(20);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@Nullable TokenSet filter, @NotNull ArrayFactory<? extends T> constructor) {
        if (constructor == null) {
            CompositeElement.$$$reportNull$$$0(21);
        }
        this.assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(22);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            PsiElement element2 = child.getPsi();
            LOG.assertTrue(element2 != null, child);
            result2[idx++] = element2;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(23);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@NotNull IElementType type2, @NotNull ArrayFactory<? extends T> constructor) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(24);
        }
        if (constructor == null) {
            CompositeElement.$$$reportNull$$$0(25);
        }
        this.assertReadAccessAllowed();
        int count = this.countChildren(type2);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(26);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            PsiElement element2 = child.getPsi();
            LOG.assertTrue(element2 != null, child);
            result2[idx++] = element2;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(27);
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter) {
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter != null && !filter.contains(child.getElementType())) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(28);
        }
        int count = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, @Nullable ASTNode anchor, @Nullable Boolean before) {
        ASTNode anchorBefore = anchor == null ? (before == null || before != false ? null : this.getFirstChildNode()) : (before != false ? anchor : anchor.getTreeNext());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(29);
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(30);
        }
        if (newElement == null) {
            CompositeElement.$$$reportNull$$$0(31);
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        this.assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e2) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e2));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start) {
        TreeElement child;
        if (start == null) {
            CompositeElement.$$$reportNull$$$0(32);
        }
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            CompositeElement.$$$reportNull$$$0(33);
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent2 = cur.getTreeParent();
        if (parent2 == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent2;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid(psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(34);
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last = ((TreeElement)child).getTreeNext();
        TreeElement first = (TreeElement)child;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            if (anchorBefore != null) {
                CompositeElement.insertBefore((TreeChangeEventImpl)destinationTreeChange, (TreeElement)anchorBefore, first);
            } else {
                CompositeElement.add((TreeChangeEventImpl)destinationTreeChange, this, first);
            }
        }, this);
    }

    @Override
    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            CompositeElement.$$$reportNull$$$0(35);
        }
        if (leafText == null) {
            CompositeElement.$$$reportNull$$$0(36);
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    @Override
    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(37);
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(38);
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(39);
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(40);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(41);
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            CompositeElement.replace((TreeChangeEventImpl)destinationTreeChange, oldChild1, newChild1);
            CompositeElement.repairRemovedElement(this, oldChild1);
        }, this);
    }

    @Override
    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        if (anotherParent == null) {
            CompositeElement.$$$reportNull$$$0(42);
        }
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(event -> CompositeElement.remove((TreeChangeEventImpl)event, (TreeElement)anotherParent.getFirstChildNode(), null), (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                TreeElement first = this.getFirstChildNode();
                TreeChangeEventImpl event = (TreeChangeEventImpl)destinationTreeChange;
                CompositeElement parent2 = this.getTreeParent();
                if (parent2 != null) {
                    event.addElementaryChange(parent2);
                }
                CompositeElement.remove(event, first, null);
                CompositeElement.add(event, this, (TreeElement)firstChild);
                if (parent2 != null) {
                    CompositeElement.repairRemovedElement(this, first);
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        if (firstChild == null) {
            CompositeElement.$$$reportNull$$$0(43);
        }
        ASTNode f2 = firstChild;
        while (f2 != lastChild) {
            ASTNode next = f2.getTreeNext();
            this.addChild(f2, anchorBefore);
            f2 = next;
        }
    }

    @Nullable
    final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = this.createPsiNoLock();
        return myWrapperUpdater.compareAndSet(this, null, wrapper) ? wrapper : Objects.requireNonNull(this.myWrapper);
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompositeElement.$$$reportNull$$$0(44);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        PsiElement prev;
        if (psi == null) {
            CompositeElement.$$$reportNull$$$0(45);
        }
        if ((prev = this.myWrapper) != null && prev != psi) {
            DebugUtil.onInvalidated(prev);
        }
        this.myWrapper = psi;
    }

    void clearPsi() {
        this.myWrapper = null;
    }

    @Override
    public final void applyInsertOnReparse(@NotNull ASTNode newChild, ASTNode anchor) {
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(46);
        }
        TreeElement newTreeElement = (TreeElement)newChild;
        newTreeElement.rawRemove();
        if (anchor != null) {
            TreeElement anchorTreeElement = (TreeElement)anchor;
            anchorTreeElement.rawInsertAfterMe(newTreeElement);
        } else {
            TreeElement firstChildNode = this.getFirstChildNode();
            if (firstChildNode != null) {
                firstChildNode.rawInsertBeforeMe(newTreeElement);
            } else {
                this.rawAddChildren(newTreeElement);
            }
        }
        newTreeElement.clearCaches();
        this.subtreeChanged();
    }

    @Override
    public final void applyDeleteOnReparse(@NotNull ASTNode oldChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(47);
        }
        ((TreeElement)oldChild).rawRemove();
        this.subtreeChanged();
    }

    @Override
    public final void applyReplaceFileOnReparse(@NotNull PsiFile psiFile, @NotNull FileASTNode newNode) {
        ASTNode firstChildNode;
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(48);
        }
        if (newNode == null) {
            CompositeElement.$$$reportNull$$$0(49);
        }
        if (this.getFirstChildNode() != null) {
            this.rawRemoveAllChildren();
        }
        if ((firstChildNode = newNode.getFirstChildNode()) != null) {
            this.rawAddChildren((TreeElement)firstChildNode);
        }
        ((PsiFileImpl)psiFile).calcTreeElement().setCharTable(newNode.getCharTable());
        this.subtreeChanged();
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(50);
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        TreeElement last;
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(51);
        }
        if ((last = this.getLastChildNode()) == null) {
            TreeElement chainLast = CompositeElement.rawSetParents(first, this);
            this.setFirstChildNode(first);
            this.setLastChildNode(chainLast);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    @NotNull
    static TreeElement rawSetParents(@NotNull TreeElement child, @NotNull CompositeElement parent2) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(52);
        }
        if (parent2 == null) {
            CompositeElement.$$$reportNull$$$0(53);
        }
        child.rawRemoveUpToWithoutNotifications(null, false);
        while (true) {
            child.setTreeParent(parent2);
            TreeElement treeNext = child.getTreeNext();
            if (treeNext == null) {
                TreeElement treeElement = child;
                if (treeElement == null) {
                    CompositeElement.$$$reportNull$$$0(54);
                }
                return treeElement;
            }
            child = treeNext;
        }
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(@NotNull CompositeElement oldParent, TreeElement oldChild) {
        if (oldParent == null) {
            CompositeElement.$$$reportNull$$$0(55);
        }
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull CompositeElement parent2, @NotNull TreeElement first) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(56);
        }
        if (parent2 == null) {
            CompositeElement.$$$reportNull$$$0(57);
        }
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(58);
        }
        destinationTreeChange.addElementaryChange(parent2);
        parent2.rawAddChildren(first);
    }

    private static void remove(@NotNull TreeChangeEventImpl destinationTreeChange, TreeElement first, TreeElement last) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(59);
        }
        if (first != null) {
            destinationTreeChange.addElementaryChange(first.getTreeParent());
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull TreeElement anchorBefore, @NotNull TreeElement first) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(60);
        }
        if (anchorBefore == null) {
            CompositeElement.$$$reportNull$$$0(61);
        }
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(62);
        }
        destinationTreeChange.addElementaryChange(anchorBefore.getTreeParent());
        anchorBefore.rawInsertBeforeMe(first);
    }

    private static void replace(@NotNull TreeChangeEventImpl sourceTreeChange, @NotNull TreeElement oldChild, @NotNull TreeElement newChild) {
        if (sourceTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(63);
        }
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(64);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(65);
        }
        sourceTreeChange.addElementaryChange(oldChild.getTreeParent());
        oldChild.rawReplaceWithList(newChild);
    }

    private static void removeChildInner(@NotNull TreeElement child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(66);
        }
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(@NotNull TreeElement first, TreeElement last) {
        FileElement fileElement;
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(67);
        }
        if ((fileElement = TreeUtil.getFileElement(first)) != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                CompositeElement.remove((TreeChangeEventImpl)destinationTreeChange, first, last);
                CompositeElement.repairRemovedElement(fileElement, first);
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 54: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 17: 
            case 18: 
            case 29: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 52: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 39: 
            case 50: 
            case 51: 
            case 58: 
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 40: 
            case 47: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 41: 
            case 46: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherParent";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParent";
                break;
            }
            case 56: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationTreeChange";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTreeChange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiElements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "drillDown";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "rawSetParents";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 54: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertThreading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadingDiagnostics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonPhysicalOrInjected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptTree";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiChildByType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiElements";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "drillDown";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "replaceAllChildrenToChildrenOf";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "applyInsertOnReparse";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "applyDeleteOnReparse";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "applyReplaceFileOnReparse";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildren";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "rawSetParents";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "repairRemovedElement";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "insertBefore";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "removeChildInner";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

