/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.platform.backend.navigation;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.platform.backend.navigation.NavigationRequests;
import ksp.com.intellij.psi.PsiDirectory;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import ksp.com.intellij.util.concurrency.annotations.RequiresReadLock;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bg\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0003\u00c0\u0006\u0001"}, d2={"Lksp/com/intellij/platform/backend/navigation/NavigationRequest;", "", "Companion", "intellij.platform.core"})
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface NavigationRequest {
    @NotNull
    public static final Companion Companion = ksp.com.intellij.platform.backend.navigation.NavigationRequest$Companion.$$INSTANCE;

    @JvmStatic
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public static NavigationRequest sourceNavigationRequest(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        return Companion.sourceNavigationRequest(project, file, offset);
    }

    @JvmStatic
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public static NavigationRequest sourceNavigationRequest(@NotNull PsiFile file, @NotNull TextRange elementRange) {
        return Companion.sourceNavigationRequest(file, elementRange);
    }

    @JvmStatic
    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public static NavigationRequest directoryNavigationRequest(@NotNull PsiDirectory directory) {
        return Companion.directoryNavigationRequest(directory);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lksp/com/intellij/platform/backend/navigation/NavigationRequest$Companion;", "", "()V", "directoryNavigationRequest", "Lksp/com/intellij/platform/backend/navigation/NavigationRequest;", "directory", "Lksp/com/intellij/psi/PsiDirectory;", "sourceNavigationRequest", "project", "Lksp/com/intellij/openapi/project/Project;", "file", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "offset", "", "Lksp/com/intellij/psi/PsiFile;", "elementRange", "Lksp/com/intellij/openapi/util/TextRange;", "intellij.platform.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final NavigationRequest sourceNavigationRequest(@NotNull Project project, @NotNull VirtualFile file, int offset) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return NavigationRequests.Companion.getInstance().sourceNavigationRequest(project, file, offset, null);
        }

        @JvmStatic
        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final NavigationRequest sourceNavigationRequest(@NotNull PsiFile file, @NotNull TextRange elementRange) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)elementRange, (String)"elementRange");
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            NavigationRequests navigationRequests = NavigationRequests.Companion.getInstance();
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return navigationRequests.sourceNavigationRequest(project, virtualFile2, elementRange.getStartOffset(), elementRange);
        }

        @JvmStatic
        @RequiresReadLock
        @RequiresBackgroundThread
        @Nullable
        public final NavigationRequest directoryNavigationRequest(@NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return NavigationRequests.Companion.getInstance().directoryNavigationRequest(directory);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

