/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.application.impl;

import java.util.function.Predicate;
import ksp.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import ksp.org.jetbrains.annotations.NotNull;

final class BulkArrayQueue<T> {
    private int tail;
    private int head;
    private Object[] myQueue = new Object[1024];

    BulkArrayQueue() {
    }

    void enqueue(@NotNull T info) {
        int newTail;
        if (info == null) {
            BulkArrayQueue.$$$reportNull$$$0(0);
        }
        if ((newTail = (this.tail + 1) % this.myQueue.length) == this.head) {
            this.growAndUnwrap(0);
            newTail = this.tail + 1;
        }
        this.myQueue[this.tail] = info;
        this.tail = newTail;
    }

    private void growAndUnwrap(int reserveAtStart) {
        int firstChunkSize;
        if (reserveAtStart < 0) {
            throw new IllegalArgumentException("illegal argument: " + reserveAtStart);
        }
        int oldCapacity = this.myQueue.length;
        int newCapacity = reserveAtStart + (oldCapacity < 100000 ? oldCapacity * 2 : oldCapacity + (oldCapacity >> 1));
        if (newCapacity <= oldCapacity + reserveAtStart) {
            throw new OutOfMemoryError("reserveAtStart: " + reserveAtStart + "; oldCapacity: " + oldCapacity);
        }
        Object[] newQueue = new Object[newCapacity];
        if (this.head <= this.tail) {
            firstChunkSize = this.tail - this.head;
        } else {
            firstChunkSize = oldCapacity - this.head;
            System.arraycopy(this.myQueue, 0, newQueue, reserveAtStart + firstChunkSize, this.tail);
        }
        System.arraycopy(this.myQueue, this.head, newQueue, reserveAtStart, firstChunkSize);
        this.tail = this.size() + reserveAtStart;
        this.head = reserveAtStart;
        this.myQueue = newQueue;
    }

    int size() {
        return this.head <= this.tail ? this.tail - this.head : this.tail + this.myQueue.length - this.head;
    }

    T pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        int nextHead = (this.head + 1) % this.myQueue.length;
        T info = this.getAndNullize(this.head);
        this.head = nextHead;
        return info;
    }

    @NotNull
    private T getAndNullize(int head) {
        Object t2 = this.myQueue[head];
        this.myQueue[head] = null;
        Object object = t2;
        if (object == null) {
            BulkArrayQueue.$$$reportNull$$$0(1);
        }
        return (T)object;
    }

    void bulkEnqueueFirst(@NotNull @NotNull ObjectArrayList<? extends @NotNull T> elements) {
        int oldCapacity;
        int emptySpace;
        int insertSize;
        if (elements == null) {
            BulkArrayQueue.$$$reportNull$$$0(2);
        }
        if ((insertSize = elements.size()) > (emptySpace = (oldCapacity = this.myQueue.length) - this.size() - 1)) {
            this.growAndUnwrap(insertSize);
        }
        int firstChunkSize = this.head <= this.tail ? Math.min(insertSize, this.head) : Math.min(insertSize, this.head - this.tail - 1);
        elements.getElements(0, this.myQueue, this.head - firstChunkSize, firstChunkSize);
        this.head -= firstChunkSize;
        if (firstChunkSize != insertSize) {
            int secondChunkSize = insertSize - firstChunkSize;
            elements.getElements(firstChunkSize, this.myQueue, oldCapacity - secondChunkSize, secondChunkSize);
            this.head = oldCapacity - secondChunkSize;
        }
    }

    void removeAll(@NotNull Predicate<? super T> shouldRemove) {
        int o2;
        if (shouldRemove == null) {
            BulkArrayQueue.$$$reportNull$$$0(3);
        }
        if (this.head <= this.tail) {
            o2 = this.head;
            for (int i2 = this.head; i2 < this.tail; ++i2) {
                T info = this.getAndNullize(i2);
                if (shouldRemove.test(info)) continue;
                this.myQueue[o2++] = info;
            }
        } else {
            T info;
            int i3;
            o2 = this.myQueue.length;
            for (i3 = this.myQueue.length - 1; i3 >= this.head; --i3) {
                info = this.getAndNullize(i3);
                if (shouldRemove.test(info)) continue;
                this.myQueue[--o2] = info;
            }
            this.head = o2 % this.myQueue.length;
            o2 = 0;
            for (i3 = 0; i3 < this.tail; ++i3) {
                info = this.getAndNullize(i3);
                if (shouldRemove.test(info)) continue;
                this.myQueue[o2++] = info;
            }
        }
        this.tail = o2;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldRemove";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/application/impl/BulkArrayQueue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndNullize";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bulkEnqueueFirst";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

