/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LanguageUtil;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lang.PsiParser;
import ksp.com.intellij.lang.java.lexer.JavaDocLexer;
import ksp.com.intellij.lang.java.lexer.JavaLexer;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.JavaDocTokenType;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import ksp.com.intellij.psi.impl.source.JavaFileElementType;
import ksp.com.intellij.psi.impl.source.PsiJavaFileImpl;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.com.intellij.psi.tree.IStubFileElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class JavaParserDefinition
implements ParserDefinition {
    public static final IStubFileElementType JAVA_FILE = new JavaFileElementType();

    @Override
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        LanguageLevel level = project != null ? LanguageLevelProjectExtension.getInstance(project).getLanguageLevel() : LanguageLevel.HIGHEST;
        return JavaParserDefinition.createLexer(level);
    }

    @NotNull
    public static Lexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(0);
        }
        return new JavaLexer(level);
    }

    @NotNull
    public static Lexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaParserDefinition.$$$reportNull$$$0(1);
        }
        return new JavaDocLexer(level);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        IStubFileElementType iStubFileElementType = JAVA_FILE;
        if (iStubFileElementType == null) {
            JavaParserDefinition.$$$reportNull$$$0(2);
        }
        return iStubFileElementType;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create(JavaElementType.LITERAL_EXPRESSION);
        if (tokenSet == null) {
            JavaParserDefinition.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type2).createPsi(node);
            if (PsiT == null) {
                JavaParserDefinition.$$$reportNull$$$0(5);
            }
            return PsiT;
        }
        throw new IllegalArgumentException("Not a Java node: " + node + " (" + type2 + ", " + type2.getLanguage() + ")");
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            JavaParserDefinition.$$$reportNull$$$0(6);
        }
        return new PsiJavaFileImpl(viewProvider);
    }

    @Override
    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN || left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST_NOT;
            if (spaceRequirements == null) {
                JavaParserDefinition.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        PsiFile containingFile2 = left.getTreeParent().getPsi().getContainingFile();
        LanguageLevel level = containingFile2 instanceof PsiJavaFile ? ((PsiJavaFile)containingFile2).getLanguageLevel() : LanguageLevel.HIGHEST;
        Lexer lexer = JavaParserDefinition.createLexer(level);
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            ParserDefinition.SpaceRequirements spaceRequirements2 = ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            if (spaceRequirements2 == null) {
                JavaParserDefinition.$$$reportNull$$$0(8);
            }
            return spaceRequirements2;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && !(text = left.getText()).isEmpty() && Character.isWhitespace(text.charAt(text.length() - 1))) {
            ParserDefinition.SpaceRequirements spaceRequirements3 = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements3 == null) {
                JavaParserDefinition.$$$reportNull$$$0(9);
            }
            return spaceRequirements3;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA) {
            text = right.getText();
            if (!text.isEmpty() && Character.isWhitespace(text.charAt(0))) {
                ParserDefinition.SpaceRequirements spaceRequirements4 = ParserDefinition.SpaceRequirements.MAY;
                if (spaceRequirements4 == null) {
                    JavaParserDefinition.$$$reportNull$$$0(10);
                }
                return spaceRequirements4;
            }
        } else if (right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            ParserDefinition.SpaceRequirements spaceRequirements5 = ParserDefinition.SpaceRequirements.MAY;
            if (spaceRequirements5 == null) {
                JavaParserDefinition.$$$reportNull$$$0(11);
            }
            return spaceRequirements5;
        }
        ParserDefinition.SpaceRequirements spaceRequirements6 = spaceRequirements;
        if (spaceRequirements6 == null) {
            JavaParserDefinition.$$$reportNull$$$0(12);
        }
        return spaceRequirements6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/java/JavaParserDefinition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/java/JavaParserDefinition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDocLexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

