/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.DependentLanguage;
import ksp.com.intellij.lang.InjectableLanguage;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.LanguageParserDefinitions;
import ksp.com.intellij.lang.MetaLanguage;
import ksp.com.intellij.lang.ParserDefinition;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.text.NaturalComparator;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.LanguageSubstitutor;
import ksp.com.intellij.psi.LanguageSubstitutors;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.templateLanguages.TemplateLanguage;
import ksp.com.intellij.testFramework.LightVirtualFile;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.kotlinx.collections.immutable.ExtensionsKt;
import ksp.kotlinx.collections.immutable.PersistentList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = (o1, o2) -> NaturalComparator.INSTANCE.compare(o1.getDisplayName(), o2.getDisplayName());
    private static final Key<List<MetaLanguage>> MATCHING_META_LANGUAGES = Key.create("MATCHING_META_LANGUAGES");

    private LanguageUtil() {
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(0);
        }
        return LanguageUtil.getLanguageForPsi(project, file, null);
    }

    @Nullable
    public static Language getLanguageForPsi(@NotNull Project project, @Nullable VirtualFile file, @Nullable FileType fileType) {
        Language fileLanguage;
        Language explicit;
        if (project == null) {
            LanguageUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return null;
        }
        Language language = explicit = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        Language language2 = explicit != null ? explicit : (fileLanguage = LanguageUtil.getFileTypeLanguage(fileType != null ? fileType : file.getFileType()));
        if (fileLanguage == null) {
            return null;
        }
        for (LanguageSubstitutor substitutor2 : LanguageSubstitutors.getInstance().forKey(Language.ANY)) {
            Language language3 = substitutor2.getLanguage(file, project);
            if (language3 == null || language3 == Language.ANY) continue;
            fileLanguage = language3;
            break;
        }
        return LanguageSubstitutors.getInstance().substituteLanguage(fileLanguage, file, project);
    }

    @Nullable
    public static Language getFileLanguage(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        Language language = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getLanguage() : null;
        return language == null ? LanguageUtil.getFileTypeLanguage(file.getFileType()) : language;
    }

    @Nullable
    public static Language getFileTypeLanguage(@NotNull FileType fileType) {
        if (fileType == null) {
            LanguageUtil.$$$reportNull$$$0(2);
        }
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    @Nullable
    public static FileType getLanguageFileType(@Nullable Language language) {
        return language == null ? null : language.getAssociatedFileType();
    }

    @NotNull
    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(@NotNull ASTNode left, @NotNull ASTNode right, @NotNull Lexer lexer) {
        if (left == null) {
            LanguageUtil.$$$reportNull$$$0(3);
        }
        if (right == null) {
            LanguageUtil.$$$reportNull$$$0(4);
        }
        if (lexer == null) {
            LanguageUtil.$$$reportNull$$$0(5);
        }
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType() || lexer.getTokenEnd() != left.getTextLength()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(6);
            }
            return spaceRequirements;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length() || lexer.getTokenType() != right.getElementType()) {
            ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MUST;
            if (spaceRequirements == null) {
                LanguageUtil.$$$reportNull$$$0(7);
            }
            return spaceRequirements;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            LanguageUtil.$$$reportNull$$$0(8);
        }
        return spaceRequirements;
    }

    @Deprecated
    @NotNull
    public static Set<Language> getAllDerivedLanguages(@NotNull Language base) {
        if (base == null) {
            LanguageUtil.$$$reportNull$$$0(9);
        }
        HashSet<Language> result2 = new HashSet<Language>();
        result2.add(base);
        result2.addAll(base.getTransitiveDialects());
        HashSet<Language> hashSet = result2;
        if (hashSet == null) {
            LanguageUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    public static boolean isInTemplateLanguageFile(@NotNull PsiElement element2) {
        PsiFile psiFile;
        if (element2 == null) {
            LanguageUtil.$$$reportNull$$$0(11);
        }
        if ((psiFile = element2.getContainingFile()) == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(12);
        }
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }

    @NotNull
    public static List<Language> getInjectableLanguages() {
        return LanguageUtil.getLanguages(LanguageUtil::isInjectableLanguage);
    }

    public static boolean isFileLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(13);
        }
        if (language instanceof DependentLanguage || language instanceof InjectableLanguage || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null) {
            return false;
        }
        LanguageFileType type2 = language.getAssociatedFileType();
        return type2 != null && !Strings.isEmpty(type2.getDefaultExtension());
    }

    @NotNull
    public static List<Language> getFileLanguages() {
        return LanguageUtil.getLanguages(LanguageUtil::isFileLanguage);
    }

    @NotNull
    public static List<Language> getLanguages(@NotNull Predicate<? super Language> filter) {
        if (filter == null) {
            LanguageUtil.$$$reportNull$$$0(14);
        }
        LanguageParserDefinitions.INSTANCE.ensureValuesLoaded();
        ArrayList<Language> result2 = new ArrayList<Language>();
        for (Language language : Language.getRegisteredLanguages()) {
            if (!filter.test(language)) continue;
            result2.add(language);
        }
        result2.sort(LANGUAGE_COMPARATOR);
        ArrayList<Language> arrayList = result2;
        if (arrayList == null) {
            LanguageUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static Language getRootLanguage(@NotNull PsiElement element2) {
        Language language;
        PsiFile containingFile2;
        FileViewProvider provider2;
        Set<Language> languages;
        if (element2 == null) {
            LanguageUtil.$$$reportNull$$$0(16);
        }
        if ((languages = (provider2 = (containingFile2 = element2.getContainingFile()).getViewProvider()).getLanguages()).size() > 1 && languages.contains(language = containingFile2.getLanguage())) {
            Language language2 = language;
            if (language2 == null) {
                LanguageUtil.$$$reportNull$$$0(17);
            }
            return language2;
        }
        Language language3 = provider2.getBaseLanguage();
        if (language3 == null) {
            LanguageUtil.$$$reportNull$$$0(18);
        }
        return language3;
    }

    @NotNull
    static List<MetaLanguage> matchingMetaLanguages(@NotNull Language language) {
        PersistentList<MetaLanguage> toCache;
        List<MetaLanguage> cached;
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(19);
        }
        if ((cached = language.getUserData(MATCHING_META_LANGUAGES)) != null) {
            List<MetaLanguage> list = cached;
            if (list == null) {
                LanguageUtil.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (!ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(MetaLanguage.EP_NAME)) {
            PersistentList<MetaLanguage> persistentList = ExtensionsKt.persistentListOf();
            if (persistentList == null) {
                LanguageUtil.$$$reportNull$$$0(21);
            }
            return persistentList;
        }
        if (language instanceof MetaLanguage) {
            toCache = ExtensionsKt.persistentListOf();
        } else {
            HashSet result2 = new HashSet();
            MetaLanguage.EP_NAME.forEachExtensionSafe(metaLanguage -> {
                if (metaLanguage.matchesLanguage(language)) {
                    result2.add(metaLanguage);
                }
            });
            toCache = result2.isEmpty() ? ExtensionsKt.persistentListOf() : ExtensionsKt.toPersistentList(result2);
        }
        language.putUserData(MATCHING_META_LANGUAGES, toCache);
        PersistentList<MetaLanguage> persistentList = toCache;
        if (persistentList == null) {
            LanguageUtil.$$$reportNull$$$0(22);
        }
        return persistentList;
    }

    static void clearMatchingMetaLanguagesCache(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(23);
        }
        language.putUserData(MATCHING_META_LANGUAGES, null);
    }

    @NotNull
    public static JBIterable<Language> getBaseLanguages(@NotNull Language language) {
        if (language == null) {
            LanguageUtil.$$$reportNull$$$0(24);
        }
        JBIterable<Language> jBIterable = JBIterable.generate(language, Language::getBaseLanguage);
        if (jBIterable == null) {
            LanguageUtil.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    @Nullable
    public static Language findRegisteredLanguage(@NotNull String langValueText) {
        Language language;
        if (langValueText == null) {
            LanguageUtil.$$$reportNull$$$0(26);
        }
        if ((language = Language.findLanguageByID(langValueText)) != null) {
            return language;
        }
        for (Language value2 : Language.getRegisteredLanguages()) {
            if (!value2.getID().equalsIgnoreCase(langValueText)) continue;
            return value2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/lang/LanguageUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langValueText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/lang/LanguageUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "canStickTokensTogetherByLexer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDerivedLanguages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootLanguage";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "matchingMetaLanguages";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguages";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeLanguage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canStickTokensTogetherByLexer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllDerivedLanguages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInTemplateLanguageFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInjectableLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFileLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLanguages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRootLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matchingMetaLanguages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "clearMatchingMetaLanguagesCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBaseLanguages";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

