/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ide.plugins;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.com.intellij.diagnostic.PluginException;
import ksp.com.intellij.ide.plugins.ClassLoaderConfigurator;
import ksp.com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import ksp.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import ksp.com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import ksp.com.intellij.ide.plugins.PluginContentDescriptor;
import ksp.com.intellij.ide.plugins.PluginSet;
import ksp.com.intellij.ide.plugins.cl.ResolveScopeManager;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.lang.UrlClassLoader;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u001a\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a$\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001a0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001b\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0007\u00a2\u0006\u0002\u0010 \"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"DEFAULT_CLASSLOADER_CONFIGURATION", "Lksp/com/intellij/util/lang/UrlClassLoader$Builder;", "Lksp/org/jetbrains/annotations/NotNull;", "log", "Lksp/com/intellij/openapi/diagnostic/Logger;", "getLog$annotations", "()V", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "configureUsingIdeaClassloader", "Ljava/lang/ClassLoader;", "classPath", "", "Ljava/nio/file/Path;", "descriptor", "Lksp/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "createModuleContentBasedScope", "Lksp/com/intellij/ide/plugins/cl/ResolveScopeManager;", "createModuleResolveScopeManager", "createPluginDependencyAndContentBasedScope", "pluginSet", "Lksp/com/intellij/ide/plugins/PluginSet;", "createScopeWithExtraPackage", "customPackage", "", "getContentPackagePrefixes", "Lkotlin/Pair;", "getDependencyPackagePrefixes", "sortDependenciesInPlace", "", "dependencies", "", "([Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "intellij.platform.core.impl"})
public final class ClassLoaderConfiguratorKt {
    @NotNull
    private static final UrlClassLoader.Builder DEFAULT_CLASSLOADER_CONFIGURATION;

    private static final Logger getLog() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    private static /* synthetic */ void getLog$annotations() {
    }

    private static final ResolveScopeManager createModuleResolveScopeManager() {
        return new ResolveScopeManager(){

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                return !StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name2, (String)"ksp.com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) ? "" : null;
            }
        };
    }

    private static final ResolveScopeManager createScopeWithExtraPackage(String customPackage) {
        return new ResolveScopeManager(customPackage){
            final /* synthetic */ String $customPackage;
            {
                this.$customPackage = $customPackage;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (!(force || StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"ksp.com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)this.$customPackage, (boolean)false, (int)2, null))) {
                    return "";
                }
                return null;
            }
        };
    }

    @VisibleForTesting
    @Nullable
    public static final ResolveScopeManager createPluginDependencyAndContentBasedScope(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginSet pluginSet) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        List<Pair<String, String>> contentPackagePrefixes = ClassLoaderConfiguratorKt.getContentPackagePrefixes(descriptor2);
        List<String> dependencyPackagePrefixes = ClassLoaderConfiguratorKt.getDependencyPackagePrefixes(descriptor2, pluginSet);
        if (contentPackagePrefixes.isEmpty() && dependencyPackagePrefixes.isEmpty()) {
            return null;
        }
        String string = descriptor2.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
        String pluginId = string;
        return new ResolveScopeManager(contentPackagePrefixes, pluginId, dependencyPackagePrefixes){
            final /* synthetic */ List<Pair<String, String>> $contentPackagePrefixes;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ List<String> $dependencyPackagePrefixes;
            {
                this.$contentPackagePrefixes = $contentPackagePrefixes;
                this.$pluginId = $pluginId;
                this.$dependencyPackagePrefixes = $dependencyPackagePrefixes;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (force) {
                    return null;
                }
                for (Pair<String, String> pair : this.$contentPackagePrefixes) {
                    String prefix = (String)pair.component1();
                    String moduleName = (String)pair.component2();
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "Class " + name2 + " must not be requested from main classloader of " + this.$pluginId + " plugin. Matches content module (packagePrefix=" + prefix + ", moduleName=" + moduleName + ").";
                }
                for (String prefix : this.$dependencyPackagePrefixes) {
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return "";
                }
                return null;
            }
        };
    }

    private static final List<Pair<String, String>> getContentPackagePrefixes(IdeaPluginDescriptorImpl descriptor2) {
        List<PluginContentDescriptor.ModuleItem> modules = descriptor2.content.modules;
        if (modules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int n2 = 0;
        int n3 = modules.size();
        Object[] objectArray = new Pair[n3];
        while (n2 < n3) {
            int n4 = n2++;
            IdeaPluginDescriptorImpl module2 = modules.get(n4).requireDescriptor();
            String string = module2.packagePrefix;
            if (string == null) {
                throw new PluginException("Package is not specified (module=" + module2 + ')', module2.getPluginId());
            }
            objectArray[n4] = TuplesKt.to((Object)(string + '.'), (Object)module2.moduleName);
        }
        Object[] result2 = objectArray;
        return ArraysKt.asList((Object[])result2);
    }

    private static final List<String> getDependencyPackagePrefixes(IdeaPluginDescriptorImpl descriptor2, PluginSet pluginSet) {
        List<ModuleDependenciesDescriptor.ModuleReference> dependencies = descriptor2.dependencies.modules;
        if (dependencies.isEmpty()) {
            List<String> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>(dependencies.size());
        for (ModuleDependenciesDescriptor.ModuleReference item : dependencies) {
            String packagePrefix;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginSet.findEnabledModule(item.name);
            if (ideaPluginDescriptorImpl == null || (packagePrefix = ideaPluginDescriptorImpl.packagePrefix) == null || Intrinsics.areEqual((Object)item.name, (Object)"intellij.platform.commercial.verifier")) continue;
            result2.add(packagePrefix + '.');
        }
        return result2;
    }

    private static final ResolveScopeManager createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        ArrayList<String> packagePrefixes = new ArrayList<String>(descriptor2.content.modules.size());
        for (PluginContentDescriptor.ModuleItem item : descriptor2.content.modules) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = item.requireDescriptor().packagePrefix;
            Intrinsics.checkNotNull((Object)string);
            packagePrefixes.add(stringBuilder.append(string).append('.').toString());
        }
        return new ResolveScopeManager(packagePrefixes){
            final /* synthetic */ ArrayList<String> $packagePrefixes;
            {
                this.$packagePrefixes = $packagePrefixes;
            }

            @Nullable
            public String isDefinitelyAlienClass(@NotNull String name2, @NotNull String packagePrefix, boolean force) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)packagePrefix, (String)"packagePrefix");
                if (StringsKt.startsWith$default((String)name2, (String)packagePrefix, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"ksp.com.intellij.ultimate.PluginVerifier", (boolean)false, (int)2, null)) {
                    return null;
                }
                for (String prefix : this.$packagePrefixes) {
                    Intrinsics.checkNotNull((Object)prefix);
                    if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
                    return null;
                }
                return "";
            }
        };
    }

    private static final ClassLoader configureUsingIdeaClassloader(List<? extends Path> classPath2, IdeaPluginDescriptorImpl descriptor2) {
        ClassLoaderConfiguratorKt.getLog().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
        ClassLoader loader = ClassLoaderConfigurator.class.getClassLoader();
        try {
            MethodHandle addFiles = MethodHandles.lookup().findVirtual(loader.getClass(), "addFiles", MethodType.methodType(Void.TYPE, List.class));
            addFiles.invoke(loader, classPath2);
            Intrinsics.checkNotNull((Object)loader);
            return loader;
        }
        catch (Throwable e2) {
            throw new IllegalStateException("An unexpected core classloader: " + loader, e2);
        }
    }

    @VisibleForTesting
    public static final void sortDependenciesInPlace(@NotNull IdeaPluginDescriptorImpl[] dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        if (dependencies.length <= 1) {
            return;
        }
        ArraysKt.sortWith((Object[])dependencies, (arg_0, arg_1) -> ClassLoaderConfiguratorKt.sortDependenciesInPlace$lambda$0(sortDependenciesInPlace.1.INSTANCE, arg_0, arg_1));
    }

    private static final int sortDependenciesInPlace$getWeight(IdeaPluginDescriptorImpl module2) {
        return module2.moduleName == null ? 1 : 0;
    }

    private static final int sortDependenciesInPlace$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ Logger access$getLog() {
        return ClassLoaderConfiguratorKt.getLog();
    }

    public static final /* synthetic */ UrlClassLoader.Builder access$getDEFAULT_CLASSLOADER_CONFIGURATION$p() {
        return DEFAULT_CLASSLOADER_CONFIGURATION;
    }

    public static final /* synthetic */ ClassLoader access$configureUsingIdeaClassloader(List classPath2, IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.configureUsingIdeaClassloader(classPath2, descriptor2);
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleResolveScopeManager() {
        return ClassLoaderConfiguratorKt.createModuleResolveScopeManager();
    }

    public static final /* synthetic */ ResolveScopeManager access$createScopeWithExtraPackage(String customPackage) {
        return ClassLoaderConfiguratorKt.createScopeWithExtraPackage(customPackage);
    }

    public static final /* synthetic */ ResolveScopeManager access$createModuleContentBasedScope(IdeaPluginDescriptorImpl descriptor2) {
        return ClassLoaderConfiguratorKt.createModuleContentBasedScope(descriptor2);
    }

    public static final /* synthetic */ int access$sortDependenciesInPlace$getWeight(IdeaPluginDescriptorImpl module2) {
        return ClassLoaderConfiguratorKt.sortDependenciesInPlace$getWeight(module2);
    }

    static {
        UrlClassLoader.Builder builder2 = UrlClassLoader.build().useCache();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"useCache(...)");
        DEFAULT_CLASSLOADER_CONFIGURATION = builder2;
    }
}

