/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import ksp.org.jetbrains.annotations.Nullable;

public class KotlinCompilerVersion {
    public static final String VERSION_FILE_PATH = "/META-INF/ksp.compiler.version";
    public static final String VERSION;
    private static final boolean IS_PRE_RELEASE = true;
    public static final String TEST_IS_PRE_RELEASE_SYSTEM_PROPERTY = "kotlin.test.is.pre.release";

    public static boolean isPreRelease() {
        String overridden = System.getProperty(TEST_IS_PRE_RELEASE_SYSTEM_PROPERTY);
        if (overridden != null) {
            return Boolean.parseBoolean(overridden);
        }
        return true;
    }

    @Nullable
    public static String getVersion() {
        return VERSION.equals("@snapshot@") ? null : VERSION;
    }

    private static String loadKotlinCompilerVersion() throws IOException {
        try (BufferedReader versionReader = new BufferedReader(new InputStreamReader(KotlinCompilerVersion.class.getResourceAsStream(VERSION_FILE_PATH)));){
            String string2 = versionReader.readLine();
            return string2;
        }
    }

    static {
        try {
            VERSION = KotlinCompilerVersion.loadKotlinCompilerVersion();
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed to read compiler version from /META-INF/ksp.compiler.version");
        }
    }
}

