/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import ksp.org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="ReplaceKFunctionInvokeWithFunctionInvoke")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ReplaceKFunctionInvokeWithFunctionInvoke;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "implicitCastKFunctionReceiverIntoFunctionIfNeeded", "parentClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
public final class ReplaceKFunctionInvokeWithFunctionInvoke
extends IrVisitorVoid
implements FileLoweringPass {
    public ReplaceKFunctionInvokeWithFunctionInvoke(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, this);
    }

    @Override
    public void visitElement(@NotNull IrElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        element2.acceptChildren(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCall(@NotNull IrCall expression2) {
        IrTypeOperatorCallImpl irTypeOperatorCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        expression2.acceptChildren(this, null);
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.INVOKE)) {
            return;
        }
        IrDeclarationParent irDeclarationParent = callee.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return;
        }
        IrClass parentClass = irClass;
        if (!IrTypeUtilsKt.isKFunction(IrUtilsKt.getDefaultType(parentClass)) && !IrTypeUtilsKt.isKSuspendFunction(IrUtilsKt.getDefaultType(parentClass))) {
            this.implicitCastKFunctionReceiverIntoFunctionIfNeeded(expression2, parentClass);
            return;
        }
        expression2.setSymbol((IrSimpleFunctionSymbol)CollectionsKt.single(callee.getOverriddenSymbols()));
        IrCall irCall = expression2;
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression != null) {
            void it;
            IrExpression irExpression2 = irExpression;
            IrCall irCall2 = irCall;
            boolean bl2 = false;
            IrSimpleType newType = IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(expression2.getSymbol().getOwner()));
            irTypeOperatorCallImpl = BuildersKt.IrTypeOperatorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newType, IrTypeOperator.IMPLICIT_CAST, newType, (IrExpression)it);
            irCall = irCall2;
        } else {
            irTypeOperatorCallImpl = null;
        }
        irCall.setDispatchReceiver(irTypeOperatorCallImpl);
    }

    private final void implicitCastKFunctionReceiverIntoFunctionIfNeeded(IrCall expression2, IrClass parentClass) {
        IrExpression receiver = expression2.getDispatchReceiver();
        if (receiver != null && (IrTypeUtilsKt.isKFunction(receiver.getType()) || IrTypeUtilsKt.isKSuspendFunction(receiver.getType()))) {
            IrSimpleType newType = IrUtilsKt.getDefaultType(parentClass);
            expression2.setDispatchReceiver(BuildersKt.IrTypeOperatorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newType, IrTypeOperator.IMPLICIT_CAST, newType, receiver));
        }
    }
}

