/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Consumer;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.org.jetbrains.annotations.NotNull;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    public SmartList() {
    }

    public SmartList(E element2) {
        this.myElem = element2;
        this.mySize = 1;
    }

    public SmartList(@NotNull Collection<? extends E> elements) {
        if (elements == null) {
            SmartList.$$$reportNull$$$0(0);
        }
        int size = elements.size();
        if (size == 1) {
            E element2 = elements instanceof List && elements instanceof RandomAccess ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element2);
        } else if (size > 0) {
            this.mySize = size;
            this.myElem = elements.toArray(new Object[size]);
        }
    }

    @SafeVarargs
    public SmartList(E ... elements) {
        if (elements == null) {
            SmartList.$$$reportNull$$$0(1);
        }
        int length = elements.length;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                this.myElem = elements[0];
                this.mySize = 1;
                break;
            }
            default: {
                this.myElem = Arrays.copyOf(elements, length);
                this.mySize = length;
            }
        }
    }

    @Override
    public E get(int index2) {
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size);
        if (size == 1) {
            return this.asElement();
        }
        return this.getFromArray(this.asArray(), index2);
    }

    private E getFromArray(Object[] objects, int index2) {
        return (E)objects[index2];
    }

    private static void checkOutOfBounds(int index2, int size) {
        if (index2 < 0 || index2 >= size) {
            throw new IndexOutOfBoundsException(SmartList.outOfBoundsMessage(index2, size));
        }
    }

    private static void checkOutOfBoundsForAdd(int index2, int size) {
        if (index2 < 0 || index2 > size) {
            throw new IndexOutOfBoundsException(SmartList.outOfBoundsMessage(index2, size));
        }
    }

    @NotNull
    private static String outOfBoundsMessage(int index2, int size) {
        String string2 = "Index: " + index2 + ", Size: " + size;
        if (string2 == null) {
            SmartList.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public boolean add(E e2) {
        int size = this.mySize;
        switch (size) {
            case 0: {
                this.myElem = e2;
                break;
            }
            case 1: {
                this.myElem = new Object[]{this.myElem, e2};
                break;
            }
            default: {
                Object[] array = this.resizeIfNecessary(size);
                array[size] = e2;
            }
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    private Object @NotNull [] resizeIfNecessary(int size) {
        Object[] array = this.asArray();
        int oldCapacity = array.length;
        if (size >= oldCapacity) {
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, size + 1);
            array = ArrayUtil.realloc(array, newCapacity, Object[]::new);
            this.myElem = array;
        }
        if (array == null) {
            SmartList.$$$reportNull$$$0(3);
        }
        return array;
    }

    @Override
    public void add(int index2, E e2) {
        int size = this.mySize;
        SmartList.checkOutOfBoundsForAdd(index2, size);
        switch (size) {
            case 0: {
                this.myElem = e2;
                break;
            }
            case 1: {
                Object[] objectArray;
                if (index2 == 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = e2;
                    objectArray = objectArray2;
                    objectArray2[1] = this.myElem;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = this.myElem;
                    objectArray = objectArray3;
                    objectArray3[1] = e2;
                }
                this.myElem = objectArray;
                break;
            }
            default: {
                Object[] array = this.resizeIfNecessary(size);
                System.arraycopy(array, index2, array, index2 + 1, size - index2);
                array[index2] = e2;
            }
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int size = this.mySize;
        int toRemove = toIndex - fromIndex;
        if (toRemove < 0) {
            throw new IndexOutOfBoundsException(SmartList.outOfBoundsMessage(fromIndex, toIndex));
        }
        ++this.modCount;
        if (toRemove == 0) {
            return;
        }
        if (toRemove == size) {
            this.myElem = null;
            this.mySize = 0;
        } else if (toRemove == size - 1) {
            Object[] array = this.asArray();
            this.myElem = array[toRemove * (1 - fromIndex)];
            this.mySize = 1;
        } else {
            Object[] array = this.asArray();
            System.arraycopy(array, toIndex, array, fromIndex, size - toIndex);
            Arrays.fill(array, toIndex, size, null);
            this.mySize = size - toRemove;
        }
    }

    @Override
    public E set(int index2, E element2) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size);
        if (size == 1) {
            oldValue = this.asElement();
            this.myElem = element2;
        } else {
            Object[] array = this.asArray();
            oldValue = this.getFromArray(array, index2);
            array[index2] = element2;
        }
        return oldValue;
    }

    private E asElement() {
        return (E)this.myElem;
    }

    private Object[] asArray() {
        return (Object[])this.myElem;
    }

    @Override
    public E remove(int index2) {
        E oldValue;
        int size = this.mySize;
        SmartList.checkOutOfBounds(index2, size);
        switch (size) {
            case 0: 
            case 1: {
                oldValue = this.asElement();
                this.myElem = null;
                break;
            }
            case 2: {
                Object[] array = this.asArray();
                oldValue = this.getFromArray(array, index2);
                this.myElem = array[1 - index2];
                break;
            }
            default: {
                Object[] array = this.asArray();
                oldValue = this.getFromArray(array, index2);
                int numMoved = size - index2 - 1;
                if (numMoved > 0) {
                    System.arraycopy(array, index2 + 1, array, index2, numMoved);
                }
                array[size - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return oldValue;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<Object> iterator2 = this.mySize == 0 ? Collections.emptyIterator() : super.iterator();
        if (iterator2 == null) {
            SmartList.$$$reportNull$$$0(4);
        }
        return iterator2;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            Arrays.sort(this.asArray(), 0, this.mySize, comparator);
        }
    }

    @Deprecated
    public int getModificationCount() {
        return this.modCount;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a2) {
        if (a2 == null) {
            SmartList.$$$reportNull$$$0(5);
        }
        int aLength = a2.length;
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                E t2 = this.asElement();
                if (aLength == 0) {
                    T[] r2 = ArrayUtil.newArray(ArrayUtil.getComponentType(a2), 1);
                    r2[0] = t2;
                    if (r2 == null) {
                        SmartList.$$$reportNull$$$0(6);
                    }
                    return r2;
                }
                a2[0] = t2;
                break;
            }
            default: {
                if (aLength < size) {
                    T[] TArray = Arrays.copyOf(this.asArray(), size, a2.getClass());
                    if (TArray == null) {
                        SmartList.$$$reportNull$$$0(7);
                    }
                    return TArray;
                }
                System.arraycopy(this.asArray(), 0, a2, 0, size);
            }
        }
        if (aLength > size) {
            a2[size] = null;
        }
        if (a2 == null) {
            SmartList.$$$reportNull$$$0(8);
        }
        return a2;
    }

    public void trimToSize() {
        int size = this.mySize;
        if (size < 2) {
            return;
        }
        Object[] array = this.asArray();
        if (size < array.length) {
            ++this.modCount;
            this.myElem = Arrays.copyOf(array, size);
        }
    }

    @Override
    public int indexOf(Object o2) {
        switch (this.mySize) {
            case 0: {
                return -1;
            }
            case 1: {
                return Objects.equals(o2, this.myElem) ? 0 : -1;
            }
        }
        return ArrayUtilRt.indexOf(this.asArray(), o2, 0, this.mySize);
    }

    @Override
    public boolean contains(Object o2) {
        return this.indexOf(o2) >= 0;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof SmartList) {
            return this.equalsWithSmartList((SmartList)o2);
        }
        if (o2 instanceof ArrayList) {
            return this.equalsWithArrayList((ArrayList)o2);
        }
        return super.equals(o2);
    }

    private boolean equalsWithSmartList(@NotNull SmartList<?> that) {
        int size;
        if (that == null) {
            SmartList.$$$reportNull$$$0(9);
        }
        if ((size = this.mySize) != that.mySize) {
            return false;
        }
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                return Objects.equals(this.myElem, that.myElem);
            }
        }
        return Arrays.equals(this.asArray(), super.asArray());
    }

    private boolean equalsWithArrayList(@NotNull ArrayList<?> that) {
        int size;
        if (that == null) {
            SmartList.$$$reportNull$$$0(10);
        }
        if ((size = this.mySize) != that.size()) {
            return false;
        }
        switch (size) {
            case 0: {
                return true;
            }
            case 1: {
                return Objects.equals(this.myElem, that.get(0));
            }
        }
        return that.equals(this);
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action) {
        if (action == null) {
            SmartList.$$$reportNull$$$0(11);
        }
        int size = this.mySize;
        switch (size) {
            case 0: {
                break;
            }
            case 1: {
                action.accept(this.asElement());
                break;
            }
            default: {
                Object[] array = this.asArray();
                for (int i2 = 0; i2 < size; ++i2) {
                    action.accept(this.getFromArray(array, i2));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/SmartList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/SmartList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "outOfBoundsMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resizeIfNecessary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithSmartList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithArrayList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

