/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/VarargWrongExecutionOrderChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nVarargWrongExecutionOrderChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargWrongExecutionOrderChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/VarargWrongExecutionOrderChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n360#2,7:46\n388#2,7:54\n1#3:53\n*S KotlinDebug\n*F\n+ 1 VarargWrongExecutionOrderChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/VarargWrongExecutionOrderChecker\n*L\n28#1:46,7\n31#1:54,7\n*E\n"})
public final class VarargWrongExecutionOrderChecker
implements CallChecker {
    @NotNull
    public static final VarargWrongExecutionOrderChecker INSTANCE = new VarargWrongExecutionOrderChecker();

    private VarargWrongExecutionOrderChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        int n2;
        int varargIndex;
        List<? extends ValueArgument> valueArguments;
        block10: {
            int n3;
            Object $this$indexOfFirst$iv;
            block9: {
                Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                boolean isCorrectExecutionOrderForVarargArgumentsAlreadyUsed = context2.getLanguageVersionSettings().getFeatureSupport(LanguageFeature.UseCorrectExecutionOrderForVarargArguments) == LanguageFeature.State.ENABLED;
                Object obj = resolvedCall2.getCandidateDescriptor();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"getCandidateDescriptor(...)");
                if (DescriptorUtilsKt.isAnnotationConstructor((DeclarationDescriptor)obj)) {
                    return;
                }
                if (isCorrectExecutionOrderForVarargArgumentsAlreadyUsed) {
                    return;
                }
                List<? extends ValueArgument> list = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueArguments(...)");
                valueArguments = list;
                $this$indexOfFirst$iv = valueArguments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends ValueArgument> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    ValueArgument item$iv;
                    ValueArgument it = item$iv = iterator2.next();
                    boolean bl2 = false;
                    ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall2, it);
                    boolean bl3 = valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
                    if (bl3) {
                        n3 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            $this$indexOfFirst$iv = n3;
            int it = ((Number)$this$indexOfFirst$iv).intValue();
            boolean bl4 = false;
            Object object = it != -1 ? $this$indexOfFirst$iv : null;
            if (object == null) {
                return;
            }
            varargIndex = (Integer)object;
            List<? extends ValueArgument> $this$indexOfLast$iv = valueArguments;
            boolean $i$f$indexOfLast = false;
            ListIterator<? extends ValueArgument> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                ValueArgument it2 = iterator$iv.previous();
                boolean bl5 = false;
                ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall2, it2);
                boolean bl6 = valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
                if (!(!bl6)) continue;
                n2 = iterator$iv.nextIndex();
                break block10;
            }
            n2 = -1;
        }
        Integer n4 = n2;
        int it = ((Number)n4).intValue();
        boolean bl7 = false;
        Integer n5 = it != -1 ? n4 : null;
        if (n5 == null) {
            return;
        }
        int nonVarargIndex = n5;
        if (varargIndex > nonVarargIndex) {
            return;
        }
        ValueArgument varargValueArgument = valueArguments.get(varargIndex);
        if (!varargValueArgument.isNamed() || !(varargValueArgument instanceof PsiElement)) {
            return;
        }
        context2.getTrace().report(Errors.CHANGING_ARGUMENTS_EXECUTION_ORDER_FOR_NAMED_VARARGS.on((PsiElement)((Object)varargValueArgument)));
    }
}

