/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCOutletChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,68:1\n34#2:69\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n*L\n63#1:69\n*E\n"})
public final class FirNativeObjCOutletChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOutletChecker INSTANCE = new FirNativeObjCOutletChecker();

    private FirNativeObjCOutletChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration2.getSymbol(), context2.getSession())) {
            FirNativeObjCOutletChecker.check$checkKotlinObjCClass(session, reporter, context2, declaration2);
        }
    }

    private static final void check$checkCanGenerateFunctionImp(DiagnosticReporter $reporter, CheckerContext $context, FirPropertyAccessor setter2) {
        if (setter2.getValueParameters().size() > 2) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)setter2.getSource(), FirNativeErrors.INSTANCE.getTWO_OR_LESS_PARAMETERS_ARE_SUPPORTED_HERE(), (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void check$checkCanGenerateOutletSetterImp(DiagnosticReporter $reporter, CheckerContext $context, FirSession session, FirProperty property2) {
        if (!property2.isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)property2.getSource(), FirNativeErrors.INSTANCE.getPROPERTY_MUST_BE_VAR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName(), (DiagnosticContext)$context, null, 16, null);
            return;
        }
        FirReceiverParameter firReceiverParameter = property2.getReceiverParameter();
        if (firReceiverParameter != null) {
            FirReceiverParameter it = firReceiverParameter;
            boolean bl2 = false;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_NOT_HAVE_EXTENSION_RECEIVER(), (Object)('@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asFqNameString()), (DiagnosticContext)$context, null, 16, null);
        }
        FirTypeRef type2 = property2.getReturnTypeRef();
        if (!FirObjCInteropKt.isObjCObjectType(type2, session)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)property2.getReturnTypeRef().getSource(), FirNativeErrors.INSTANCE.getMUST_BE_OBJC_OBJECT_TYPE(), (Object)("" + '@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName() + " type"), (Object)FirTypeUtilsKt.getConeType(type2), (DiagnosticContext)$context, null, 32, null);
        }
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        Intrinsics.checkNotNull((Object)firPropertyAccessor);
        FirNativeObjCOutletChecker.check$checkCanGenerateFunctionImp($reporter, $context, firPropertyAccessor);
    }

    private static final void check$checkKotlinObjCClass(FirSession session, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirProperty) || !FirAnnotationUtilsKt.hasAnnotation(((FirProperty)decl).getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCOutletClassId(), session)) continue;
            FirNativeObjCOutletChecker.check$checkCanGenerateOutletSetterImp($reporter, $context, session, (FirProperty)decl);
        }
    }
}

